// <auto-generated>
// This file was automatically generated. Do not edit manually.


// src/types/Gender.ts
var Gender = /* @__PURE__ */ ((Gender2) => {
  Gender2["Male"] = "Male";
  Gender2["Female"] = "Female";
  Gender2["Other"] = "Other";
  return Gender2;
})(Gender || {});

// src/utils/UsernameEmailGenerator.ts
var _UsernameEmailGenerator = class _UsernameEmailGenerator {
  constructor() {
    this.symbols = [".", "-"];
  }
  /**
   * Generate a username based on an identity.
   */
  generateUsername(identity) {
    let username = this.generateEmailPrefix(identity);
    username = username.replace(/[^a-zA-Z0-9]/g, "");
    if (username.length < _UsernameEmailGenerator.MIN_LENGTH) {
      username += this.generateRandomString(_UsernameEmailGenerator.MIN_LENGTH - username.length);
    } else if (username.length > _UsernameEmailGenerator.MAX_LENGTH) {
      username = username.substring(0, _UsernameEmailGenerator.MAX_LENGTH);
    }
    return username;
  }
  /**
   * Generate an email prefix based on an identity.
   */
  generateEmailPrefix(identity) {
    const parts = [];
    if (typeof identity.birthDate === "string") {
      identity.birthDate = new Date(identity.birthDate);
    }
    switch (this.getSecureRandom(4)) {
      case 0:
        parts.push(identity.firstName.substring(0, 1).toLowerCase() + identity.lastName.toLowerCase());
        break;
      case 1:
        parts.push((identity.firstName + identity.lastName).toLowerCase());
        break;
      case 2:
        parts.push(identity.firstName.toLowerCase() + identity.lastName.substring(0, 1).toLowerCase());
        break;
      case 3:
        parts.push(identity.firstName.substring(0, Math.min(3, identity.firstName.length)).toLowerCase() + identity.lastName.toLowerCase());
        break;
    }
    switch (this.getSecureRandom(2)) {
      case 0:
        parts.push(identity.birthDate.getFullYear().toString());
        break;
      case 1:
        parts.push(identity.birthDate.getFullYear().toString().substring(2));
        break;
    }
    let emailPrefix = parts.join(this.getRandomSymbol());
    if (this.getSecureRandom(2) === 0) {
      const position = this.getSecureRandom(emailPrefix.length);
      emailPrefix = emailPrefix.slice(0, position) + this.getRandomSymbol() + emailPrefix.slice(position);
    }
    emailPrefix = this.sanitizeEmailPrefix(emailPrefix);
    if (emailPrefix.length < _UsernameEmailGenerator.MIN_LENGTH) {
      emailPrefix += this.generateRandomString(_UsernameEmailGenerator.MIN_LENGTH - emailPrefix.length);
    } else if (emailPrefix.length > _UsernameEmailGenerator.MAX_LENGTH) {
      emailPrefix = emailPrefix.substring(0, _UsernameEmailGenerator.MAX_LENGTH);
    }
    return emailPrefix;
  }
  /**
   * Sanitize an email prefix.
   */
  sanitizeEmailPrefix(input) {
    let sanitized = input.replace(/[^a-zA-Z0-9._-]/g, "");
    sanitized = sanitized.replace(/[-_.]{2,}/g, (match) => match[0]);
    sanitized = sanitized.replace(/^[-._]+/, "");
    sanitized = sanitized.replace(/[-._]*$/, "");
    return sanitized;
  }
  /**
   * Get a random symbol.
   */
  getRandomSymbol() {
    return this.getSecureRandom(3) === 0 ? this.symbols[this.getSecureRandom(this.symbols.length)] : "";
  }
  /**
   * Generate a random string.
   */
  generateRandomString(length) {
    const chars = "abcdefghijklmnopqrstuvwxyz0123456789";
    return Array.from({ length }, () => chars.charAt(this.getSecureRandom(chars.length))).join("");
  }
  /**
   * Generate a secure random integer between 0 (inclusive) and max (exclusive)
   */
  getSecureRandom(max) {
    const array = new Uint32Array(1);
    crypto.getRandomValues(array);
    return array[0] % max;
  }
};
_UsernameEmailGenerator.MIN_LENGTH = 6;
_UsernameEmailGenerator.MAX_LENGTH = 20;
var UsernameEmailGenerator = _UsernameEmailGenerator;

// src/implementations/base/IdentityGenerator.ts
var IdentityGenerator = class {
  /**
   * Constructor.
   */
  constructor() {
    this.firstNamesMale = [];
    this.firstNamesFemale = [];
    this.lastNames = [];
    this.random = Math.random;
    this.firstNamesMale = this.getFirstNamesMaleJson();
    this.firstNamesFemale = this.getFirstNamesFemaleJson();
    this.lastNames = this.getLastNamesJson();
  }
  /**
   * Generate a random date of birth.
   */
  generateRandomDateOfBirth() {
    const today = /* @__PURE__ */ new Date();
    const minAge = 21;
    const maxAge = 65;
    const minDate = new Date(today.getFullYear() - maxAge, today.getMonth(), today.getDate());
    const maxDate = new Date(today.getFullYear() - minAge, today.getMonth(), today.getDate());
    const timestamp = minDate.getTime() + this.random() * (maxDate.getTime() - minDate.getTime());
    return new Date(timestamp);
  }
  /**
   * Generate a random identity.
   */
  generateRandomIdentity(gender) {
    const identity = {
      firstName: "",
      lastName: "",
      gender: "Male" /* Male */,
      birthDate: /* @__PURE__ */ new Date(),
      emailPrefix: "",
      nickName: ""
    };
    let selectedGender;
    if (gender === "random" || gender === void 0) {
      selectedGender = this.random() < 0.5 ? "Male" /* Male */ : "Female" /* Female */;
    } else {
      if (gender === "male") {
        selectedGender = "Male" /* Male */;
      } else if (gender === "female") {
        selectedGender = "Female" /* Female */;
      } else {
        selectedGender = "Male" /* Male */;
      }
    }
    identity.gender = selectedGender;
    if (selectedGender === "Male" /* Male */) {
      identity.firstName = this.firstNamesMale[Math.floor(this.random() * this.firstNamesMale.length)];
    } else if (selectedGender === "Female" /* Female */) {
      identity.firstName = this.firstNamesFemale[Math.floor(this.random() * this.firstNamesFemale.length)];
    } else {
      const usesMaleNames = this.random() < 0.5;
      identity.firstName = usesMaleNames ? this.firstNamesMale[Math.floor(this.random() * this.firstNamesMale.length)] : this.firstNamesFemale[Math.floor(this.random() * this.firstNamesFemale.length)];
    }
    identity.lastName = this.lastNames[Math.floor(this.random() * this.lastNames.length)];
    identity.birthDate = this.generateRandomDateOfBirth();
    const generator = new UsernameEmailGenerator();
    identity.emailPrefix = generator.generateEmailPrefix(identity);
    identity.nickName = generator.generateUsername(identity);
    return identity;
  }
};

// src/dictionaries/en/firstnames_male.ts
var firstnames_male_default = [
  "Aaron",
  "Adam",
  "Adrian",
  "Aidan",
  "Aiden",
  "Alan",
  "Albert",
  "Alex",
  "Alexander",
  "Alfred",
  "Amir",
  "Andrew",
  "Anthony",
  "Antonio",
  "Archer",
  "Arthur",
  "Asher",
  "Austin",
  "Axel",
  "Barry",
  "Beau",
  "Beckett",
  "Benjamin",
  "Bennett",
  "Bernard",
  "Blake",
  "Braden",
  "Bradley",
  "Brady",
  "Brandon",
  "Braxton",
  "Brayden",
  "Brendan",
  "Brett",
  "Brian",
  "Bruce",
  "Bryan",
  "Bryce",
  "Bryson",
  "Caden",
  "Caleb",
  "Calvin",
  "Camden",
  "Cameron",
  "Carlos",
  "Carson",
  "Carter",
  "Casey",
  "Cecil",
  "Charles",
  "Chase",
  "Chester",
  "Christian",
  "Christopher",
  "Clarence",
  "Claude",
  "Clifford",
  "Clyde",
  "Cody",
  "Cole",
  "Colin",
  "Collin",
  "Colton",
  "Connor",
  "Cooper",
  "Corey",
  "Craig",
  "Curtis",
  "Dakota",
  "Dale",
  "Dalton",
  "Damian",
  "Dan",
  "Daniel",
  "Darrell",
  "Daryl",
  "David",
  "Dawson",
  "Dean",
  "Declan",
  "Dennis",
  "Derek",
  "Devin",
  "Dominic",
  "Dominick",
  "Don",
  "Douglas",
  "Dustin",
  "Dylan",
  "Earl",
  "Easton",
  "Edgar",
  "Edmund",
  "Edward",
  "Edwin",
  "Eli",
  "Elias",
  "Elijah",
  "Elliot",
  "Elliott",
  "Emilio",
  "Emmett",
  "Eric",
  "Ethan",
  "Eugene",
  "Evan",
  "Everett",
  "Felix",
  "Ferdinand",
  "Floyd",
  "Forrest",
  "Francis",
  "Franklin",
  "Frederick",
  "Gabriel",
  "Gael",
  "Garrett",
  "Gary",
  "Gavin",
  "George",
  "Gerald",
  "Gilbert",
  "Glen",
  "Gordon",
  "Graham",
  "Grant",
  "Grayson",
  "Gregory",
  "Greyson",
  "Harold",
  "Harrison",
  "Harvey",
  "Hayden",
  "Henry",
  "Herman",
  "Howard",
  "Hudson",
  "Hugh",
  "Hugo",
  "Hunter",
  "Ian",
  "Irving",
  "Isaac",
  "Isaiah",
  "Ivan",
  "Jace",
  "Jack",
  "Jackson",
  "Jacob",
  "Jaden",
  "James",
  "Jared",
  "Jason",
  "Jasper",
  "Jayden",
  "Jeffrey",
  "Jeremiah",
  "Jeremy",
  "Jerome",
  "Jesse",
  "Jesus",
  "Joel",
  "John",
  "Jonathan",
  "Jordan",
  "Jorge",
  "Jose",
  "Joseph",
  "Joshua",
  "Josiah",
  "Juan",
  "Justin",
  "Kai",
  "Kayden",
  "Keith",
  "Kenneth",
  "Kevin",
  "Kingston",
  "Knox",
  "Kyle",
  "Landon",
  "Lawrence",
  "Leo",
  "Leon",
  "Leonard",
  "Leonardo",
  "Leslie",
  "Levi",
  "Liam",
  "Lincoln",
  "Lloyd",
  "Logan",
  "Luca",
  "Lucas",
  "Luis",
  "Luke",
  "Maddox",
  "Malachi",
  "Malcolm",
  "Marcus",
  "Mark",
  "Martin",
  "Marvin",
  "Mason",
  "Mateo",
  "Matthew",
  "Maurice",
  "Max",
  "Maxwell",
  "Micah",
  "Michael",
  "Miguel",
  "Miles",
  "Milton",
  "Mitchell",
  "Morris",
  "Nathan",
  "Nathaniel",
  "Neil",
  "Nelson",
  "Nicholas",
  "Noah",
  "Nolan",
  "Norman",
  "Oliver",
  "Oscar",
  "Owen",
  "Parker",
  "Patrick",
  "Paul",
  "Perry",
  "Peter",
  "Philip",
  "Phillip",
  "Preston",
  "Ralph",
  "Randy",
  "Ray",
  "Raymond",
  "Rhett",
  "Richard",
  "Riley",
  "Robert",
  "Roderick",
  "Rodney",
  "Roger",
  "Roland",
  "Roman",
  "Ronald",
  "Ross",
  "Roy",
  "Russell",
  "Ryan",
  "Ryder",
  "Ryker",
  "Samuel",
  "Sawyer",
  "Scott",
  "Sean",
  "Sebastian",
  "Seth",
  "Shane",
  "Shawn",
  "Silas",
  "Simon",
  "Spencer",
  "Stanley",
  "Stephen",
  "Steven",
  "Stuart",
  "Tanner",
  "Terrence",
  "Theodore",
  "Thomas",
  "Timothy",
  "Travis",
  "Trevor",
  "Tristan",
  "Tyler",
  "Vernon",
  "Victor",
  "Vincent",
  "Wade",
  "Wallace",
  "Walter",
  "Warren",
  "Wayne",
  "Wendell",
  "Wesley",
  "Weston",
  "William",
  "Winston",
  "Wyatt",
  "Xavier",
  "Zachariah",
  "Zachary",
  "Zane"
];

// src/dictionaries/en/firstnames_female.ts
var firstnames_female_default = [
  "Aaliyah",
  "Abigail",
  "Ada",
  "Adalyn",
  "Adalynn",
  "Addison",
  "Adeline",
  "Adriana",
  "Alexa",
  "Alexandra",
  "Alice",
  "Alina",
  "Allison",
  "Alyssa",
  "Amara",
  "Amaya",
  "Amelia",
  "Anastasia",
  "Andrea",
  "Anna",
  "Annabelle",
  "Aria",
  "Ariana",
  "Arianna",
  "Arielle",
  "Arya",
  "Ashley",
  "Aspen",
  "Athena",
  "Aubree",
  "Aubrey",
  "Audrey",
  "Aurora",
  "Autumn",
  "Ava",
  "Avery",
  "Ayla",
  "Bailey",
  "Beatrice",
  "Bella",
  "Bianca",
  "Blair",
  "Brianna",
  "Brielle",
  "Brooklyn",
  "Brynn",
  "Calliope",
  "Camila",
  "Camille",
  "Carmen",
  "Caroline",
  "Cassidy",
  "Catalina",
  "Cecilia",
  "Celeste",
  "Charlie",
  "Charlotte",
  "Chloe",
  "Claire",
  "Clara",
  "Cora",
  "Coraline",
  "Dahlia",
  "Daisy",
  "Dakota",
  "Daphne",
  "Dawn",
  "Delilah",
  "Diana",
  "Eden",
  "Eleanor",
  "Elena",
  "Eliana",
  "Elise",
  "Eliza",
  "Elizabeth",
  "Ella",
  "Ellie",
  "Eloise",
  "Ember",
  "Emerson",
  "Emersyn",
  "Emery",
  "Emilia",
  "Emily",
  "Emma",
  "Esme",
  "Esther",
  "Eva",
  "Evangeline",
  "Evelyn",
  "Everly",
  "Faith",
  "Fiona",
  "Flora",
  "Florence",
  "Francesca",
  "Freya",
  "Gabriella",
  "Gemma",
  "Genesis",
  "Georgia",
  "Gianna",
  "Giselle",
  "Grace",
  "Gwendolyn",
  "Hadley",
  "Hailey",
  "Hannah",
  "Harlow",
  "Harmony",
  "Harper",
  "Haven",
  "Hazel",
  "Heidi",
  "Helena",
  "Holly",
  "Hope",
  "Imogen",
  "India",
  "Indie",
  "Iris",
  "Isabel",
  "Isabella",
  "Isabelle",
  "Isla",
  "Ivy",
  "Jade",
  "Jasmine",
  "Jessie",
  "Jocelyn",
  "Josephine",
  "Josie",
  "Julia",
  "Juliana",
  "Juliet",
  "June",
  "Juniper",
  "Kaia",
  "Katherine",
  "Kayla",
  "Kaylee",
  "Keira",
  "Kennedy",
  "Khloe",
  "Kinsley",
  "Kylie",
  "Lara",
  "Laura",
  "Laurel",
  "Layla",
  "Leah",
  "Leilani",
  "Lena",
  "Liliana",
  "Lillian",
  "Lily",
  "Lola",
  "Lorelei",
  "Lucia",
  "Lucy",
  "Luna",
  "Lydia",
  "Lyla",
  "Mabel",
  "Mackenzie",
  "Madeline",
  "Madelyn",
  "Madison",
  "Maeve",
  "Magnolia",
  "Maisie",
  "Malia",
  "Margaret",
  "Margot",
  "Maria",
  "Marina",
  "Marlowe",
  "Mary",
  "Matilda",
  "Maya",
  "Melanie",
  "Melody",
  "Mia",
  "Mira",
  "Miranda",
  "Morgan",
  "Nadia",
  "Naomi",
  "Natalia",
  "Natalie",
  "Nell",
  "Nevaeh",
  "Nina",
  "Noelle",
  "Nora",
  "Norah",
  "Nova",
  "Octavia",
  "Odette",
  "Olive",
  "Olivia",
  "Opal",
  "Ophelia",
  "Paisley",
  "Pearl",
  "Penelope",
  "Peyton",
  "Phoebe",
  "Phoenix",
  "Piper",
  "Poppy",
  "Primrose",
  "Quinn",
  "Raelynn",
  "Ramona",
  "Raven",
  "Reagan",
  "Reese",
  "Riley",
  "River",
  "Robin",
  "Rosalie",
  "Rose",
  "Rosemary",
  "Rowan",
  "Ruby",
  "Ruth",
  "Rylee",
  "Ryleigh",
  "Sabrina",
  "Sadie",
  "Sage",
  "Salem",
  "Samantha",
  "Sarah",
  "Sasha",
  "Savannah",
  "Scarlett",
  "Selena",
  "Serena",
  "Serenity",
  "Sienna",
  "Sierra",
  "Simone",
  "Skye",
  "Skylar",
  "Sloane",
  "Sofia",
  "Sophia",
  "Sophie",
  "Stella",
  "Summer",
  "Sylvia",
  "Sylvie",
  "Talia",
  "Taylor",
  "Tessa",
  "Thea",
  "Thora",
  "Valentina",
  "Valeria",
  "Vera",
  "Victoria",
  "Violet",
  "Vivian",
  "Vivienne",
  "Willa",
  "Willow",
  "Winnie",
  "Winter",
  "Wren",
  "Ximena",
  "Yara",
  "Zara",
  "Zoe",
  "Zoey"
];

// src/dictionaries/en/lastnames.ts
var lastnames_default = [
  "Abbott",
  "Adams",
  "Aguilar",
  "Alexander",
  "Allen",
  "Alvarez",
  "Anderson",
  "Atkins",
  "Bailey",
  "Baker",
  "Baldwin",
  "Ballard",
  "Barber",
  "Barker",
  "Barnes",
  "Barrett",
  "Bauer",
  "Baxter",
  "Beard",
  "Bell",
  "Bennett",
  "Benson",
  "Black",
  "Blackwood",
  "Blake",
  "Blanchard",
  "Booth",
  "Bowman",
  "Bradley",
  "Briggs",
  "Brooks",
  "Brown",
  "Bryant",
  "Buckley",
  "Burke",
  "Burns",
  "Butler",
  "Byrd",
  "Cain",
  "Campbell",
  "Cannon",
  "Carlson",
  "Carter",
  "Castillo",
  "Castro",
  "Chandler",
  "Chapman",
  "Chavez",
  "Chen",
  "Clark",
  "Clarke",
  "Cobb",
  "Cole",
  "Coleman",
  "Collier",
  "Collins",
  "Conrad",
  "Cook",
  "Cooke",
  "Cooper",
  "Cox",
  "Craig",
  "Crawford",
  "Cross",
  "Cruz",
  "Cunningham",
  "Dalton",
  "Daniel",
  "Davenport",
  "Davis",
  "Dawson",
  "Dempsey",
  "Dennis",
  "Diaz",
  "Dickerson",
  "Dillon",
  "Dixon",
  "Doyle",
  "Duran",
  "Dyer",
  "Edwards",
  "Ellis",
  "Erickson",
  "Evans",
  "Ewing",
  "Farley",
  "Farr",
  "Farrell",
  "Fernandez",
  "Ferris",
  "Fisher",
  "Fitzgerald",
  "Fleming",
  "Fletcher",
  "Flores",
  "Foley",
  "Ford",
  "Foster",
  "Fowler",
  "Frazier",
  "Freeman",
  "Frost",
  "Fuller",
  "Gallagher",
  "Garcia",
  "Gardner",
  "Garner",
  "Garrett",
  "Gates",
  "Gibbs",
  "Gibson",
  "Gill",
  "Glover",
  "Goldberg",
  "Gomez",
  "Gonzales",
  "Gonzalez",
  "Goodman",
  "Goodwin",
  "Gordon",
  "Graham",
  "Graves",
  "Gray",
  "Green",
  "Griffin",
  "Griffith",
  "Gross",
  "Gutierrez",
  "Guzman",
  "Hale",
  "Hall",
  "Hamilton",
  "Hancock",
  "Harmon",
  "Harris",
  "Harrison",
  "Hawkins",
  "Hayes",
  "Hayward",
  "Henderson",
  "Hendricks",
  "Henry",
  "Hensley",
  "Hernandez",
  "Herrera",
  "Hicks",
  "Hill",
  "Hodges",
  "Holland",
  "Holmes",
  "Holt",
  "Hoover",
  "Howard",
  "Hudson",
  "Huffman",
  "Hughes",
  "Humphrey",
  "Hunter",
  "Hutchinson",
  "Isaac",
  "Jackson",
  "Jacobson",
  "James",
  "Jarvis",
  "Jenkins",
  "Jimenez",
  "Johnson",
  "Jones",
  "Jordan",
  "Keller",
  "Kelly",
  "Kennedy",
  "Kent",
  "Kerr",
  "Kim",
  "King",
  "Kirby",
  "Knowles",
  "Koch",
  "Landry",
  "Lang",
  "Lawson",
  "Lee",
  "Levy",
  "Lewis",
  "Livingston",
  "Logan",
  "Long",
  "Lopez",
  "Lowery",
  "Lowry",
  "Lucas",
  "Luna",
  "Malone",
  "Manning",
  "Marsh",
  "Marshall",
  "Martin",
  "Martinez",
  "Mason",
  "May",
  "McBride",
  "McCoy",
  "McDonald",
  "McKinney",
  "Mccarthy",
  "Mcguire",
  "Mckay",
  "Mckenzie",
  "Meadows",
  "Medina",
  "Mendez",
  "Mendoza",
  "Middleton",
  "Miller",
  "Miranda",
  "Mitchell",
  "Moody",
  "Moore",
  "Morales",
  "Moreno",
  "Morgan",
  "Morris",
  "Morse",
  "Murphy",
  "Murray",
  "Myers",
  "Nash",
  "Neal",
  "Nelson",
  "Nguyen",
  "Nichols",
  "Nielsen",
  "Nixon",
  "Norton",
  "Olson",
  "Orr",
  "Ortiz",
  "Owens",
  "Palmer",
  "Parker",
  "Parsons",
  "Patel",
  "Patterson",
  "Payne",
  "Pearce",
  "Pearson",
  "Perez",
  "Perry",
  "Peterson",
  "Phillips",
  "Pickett",
  "Pollard",
  "Porter",
  "Potter",
  "Powell",
  "Pratt",
  "Preston",
  "Price",
  "Ramirez",
  "Ramos",
  "Randall",
  "Ray",
  "Reed",
  "Reyes",
  "Reynolds",
  "Richardson",
  "Riddle",
  "Riley",
  "Rivera",
  "Roach",
  "Robbins",
  "Roberts",
  "Robinson",
  "Rodriguez",
  "Rogers",
  "Romero",
  "Ross",
  "Rowe",
  "Ruiz",
  "Russell",
  "Salinas",
  "Sanchez",
  "Sanders",
  "Santana",
  "Savage",
  "Sawyer",
  "Schmidt",
  "Schultz",
  "Scott",
  "Sellers",
  "Shannon",
  "Sharp",
  "Shaw",
  "Shepherd",
  "Shields",
  "Short",
  "Silva",
  "Simmons",
  "Simpson",
  "Skinner",
  "Sloan",
  "Smith",
  "Snyder",
  "Sparks",
  "Spears",
  "Stanley",
  "Stark",
  "Steele",
  "Stephenson",
  "Stevens",
  "Stewart",
  "Stokes",
  "Sullivan",
  "Sutton",
  "Swanson",
  "Tanner",
  "Tate",
  "Taylor",
  "Thomas",
  "Thompson",
  "Thornton",
  "Torres",
  "Tran",
  "Travis",
  "Tucker",
  "Turner",
  "Tyler",
  "Underwood",
  "Vargas",
  "Vasquez",
  "Vincent",
  "Wagner",
  "Walker",
  "Wallace",
  "Walters",
  "Walton",
  "Ward",
  "Washington",
  "Watkins",
  "Watson",
  "Weaver",
  "Webb",
  "Weeks",
  "Welch",
  "Wells",
  "West",
  "Whitaker",
  "White",
  "Wilcox",
  "Wilkinson",
  "Williams",
  "Willis",
  "Wilson",
  "Winters",
  "Wise",
  "Wolfe",
  "Wood",
  "Woods",
  "Woodward",
  "Wright",
  "Wyatt",
  "Yates",
  "York",
  "Young",
  "Zamora",
  "Zimmerman"
];

// src/implementations/IdentityGeneratorEn.ts
var IdentityGeneratorEn = class extends IdentityGenerator {
  /**
   * Get the male first names.
   */
  getFirstNamesMaleJson() {
    return firstnames_male_default;
  }
  /**
   * Get the female first names.
   */
  getFirstNamesFemaleJson() {
    return firstnames_female_default;
  }
  /**
   * Get the last names.
   */
  getLastNamesJson() {
    return lastnames_default;
  }
};

// src/dictionaries/nl/firstnames_male.ts
var firstnames_male_default2 = [
  "Daan",
  "Luuk",
  "Sem",
  "Finn",
  "Milan",
  "Levi",
  "Noah",
  "Lucas",
  "Jesse",
  "Thijs",
  "Jayden",
  "Bram",
  "Lars",
  "Ruben",
  "Thomas",
  "Tim",
  "Sam",
  "Liam",
  "Julian",
  "Mees",
  "Ties",
  "Sven",
  "Max",
  "Gijs",
  "David",
  "Stijn",
  "Jasper",
  "Niels",
  "Jens",
  "Timo",
  "Cas",
  "Joep",
  "Roan",
  "Tom",
  "Tygo",
  "Teun",
  "Siem",
  "Mats",
  "Thijmen",
  "Rens",
  "Niek",
  "Tobias",
  "Dex",
  "Hugo",
  "Robin",
  "Nick",
  "Floris",
  "Pepijn",
  "Boaz",
  "Olivier",
  "Luca",
  "Jurre",
  "Jelle",
  "Guus",
  "Koen",
  "Bart",
  "Olaf",
  "Wessel",
  "Dani\xEBl",
  "Job",
  "Sander",
  "Tijmen",
  "Kai",
  "Quinten",
  "Owen",
  "Morris",
  "Fedde",
  "Joris",
  "Jesper",
  "Mick",
  "Ryan",
  "Milo",
  "Stan",
  "Benjamin",
  "Melle",
  "Jip",
  "Dylan",
  "Brent",
  "Mick",
  "Dean",
  "Otis",
  "Abel",
  "Luc",
  "Sepp",
  "Vince",
  "Rayan",
  "Noud",
  "Hidde",
  "Fabian",
  "Jort",
  "Damian",
  "Boris",
  "Sil",
  "Moos",
  "Aiden",
  "Sep",
  "Mika",
  "Mijs",
  "Mika",
  "Felix",
  "Merlijn",
  "Alexander",
  "Aron",
  "Arthur",
  "Axel",
  "Bas",
  "Bastiaan",
  "Berend",
  "Bj\xF6rn",
  "Casper",
  "Cees",
  "Chris",
  "Christian",
  "Christiaan",
  "Colin",
  "Cornelis",
  "Dani",
  "Dennis",
  "Dirk",
  "Dominic",
  "Eduard",
  "Eelco",
  "Erik",
  "Erwin",
  "Ezra",
  "Faas",
  "Filip",
  "Florian",
  "Frank",
  "Frederik",
  "Freek",
  "Gerard",
  "Gerrit",
  "Giel",
  "Gijs",
  "Glenn",
  "Govert",
  "Harm",
  "Harold",
  "Hendrik",
  "Henrik",
  "Huub",
  "Ian",
  "Ivo",
  "Jacob",
  "Jake",
  "Jan",
  "Jarno",
  "Jason",
  "Jeffrey",
  "Jeremy",
  "Jim",
  "Jimmy",
  "Johan",
  "Johannes",
  "Jonas",
  "Jonathan",
  "Jos",
  "Joshua",
  "Justin",
  "Kay",
  "Kevin",
  "Kjeld",
  "Klaas",
  "Lennard",
  "Lennart",
  "Leon",
  "Lex",
  "Liam",
  "Loek",
  "Lorenzo",
  "Louis",
  "Lowie",
  "Maarten",
  "Magnus",
  "Maikel",
  "Marc",
  "Marcel",
  "Marco",
  "Martijn",
  "Mathias",
  "Matthijs",
  "Maurits",
  "Menno",
  "Michiel",
  "Nathan",
  "Nico",
  "Oscar",
  "Pascal",
  "Patrick",
  "Paul",
  "Peter",
  "Philip",
  "Pieter",
  "Pim",
  "Quincy",
  "Remco",
  "Rick",
  "Rik",
  "Robert",
  "Rogier",
  "Rowan",
  "Ruud",
  "Simon",
  "Stefan",
  "Steven",
  "Thom",
  "Victor",
  "Vincent",
  "Willem",
  "Wouter",
  "Yannick"
];

// src/dictionaries/nl/firstnames_female.ts
var firstnames_female_default2 = [
  "Emma",
  "Sophie",
  "Julia",
  "Mila",
  "Tess",
  "Sara",
  "Anna",
  "Noor",
  "Lotte",
  "Liv",
  "Eva",
  "Nora",
  "Zo\xEB",
  "Evi",
  "Yara",
  "Saar",
  "Nina",
  "Fenna",
  "Lieke",
  "Fleur",
  "Isa",
  "Roos",
  "Lynn",
  "Sofie",
  "Sarah",
  "Milou",
  "Olivia",
  "Maud",
  "Lisa",
  "Vera",
  "Luna",
  "Lina",
  "Noa",
  "Feline",
  "Lo\xEFs",
  "Lena",
  "Floor",
  "Charlotte",
  "Esmee",
  "Julie",
  "Iris",
  "Lara",
  "Amber",
  "Hailey",
  "Mia",
  "Lize",
  "Isabelle",
  "Cato",
  "Fenne",
  "Sanne",
  "Norah",
  "Sophia",
  "Ella",
  "Nova",
  "Elin",
  "Femke",
  "Lizzy",
  "Linde",
  "Lauren",
  "Rosalie",
  "Lana",
  "Emily",
  "Elise",
  "Esm\xE9e",
  "Anne",
  "Isabelle",
  "Demi",
  "Hannah",
  "Liva",
  "Suze",
  "Fay",
  "Isabel",
  "Benthe",
  "Evi",
  "Amy",
  "Jasmijn",
  "Niene",
  "Sterre",
  "Fenna",
  "Fiene",
  "Liz",
  "Ise",
  "Mara",
  "Nienke",
  "Indy",
  "Romy",
  "Lola",
  "Puck",
  "Nora",
  "Merel",
  "Bente",
  "Eline",
  "Lily",
  "Leah",
  "Naomi",
  "Mirthe",
  "Valerie",
  "Noor",
  "Liva",
  "Jade",
  "Juul",
  "Lise",
  "Myrthe",
  "Veerle",
  "Aafke",
  "Alicia",
  "Amira",
  "Aniek",
  "Annabel",
  "Annelies",
  "Anouk",
  "Astrid",
  "Babette",
  "Bianca",
  "Britt",
  "Carlijn",
  "Chantal",
  "Claire",
  "Dagmar",
  "Danique",
  "Daphne",
  "Denise",
  "Dominique",
  "Doris",
  "Eefje",
  "Elena",
  "Eline",
  "Elisa",
  "Elisabeth",
  "Ellen",
  "Esther",
  "Eveline",
  "Fabienne",
  "Felice",
  "Fleur",
  "Frederique",
  "Gwen",
  "Hanna",
  "Heleen",
  "Helena",
  "Ilona",
  "Imke",
  "Inge",
  "Irene",
  "Iris",
  "Janna",
  "Janneke",
  "Jasmine",
  "Jennifer",
  "Jessica",
  "Joelle",
  "Judith",
  "Julia",
  "Karin",
  "Karlijn",
  "Kim",
  "Kirsten",
  "Kyra",
  "Laura",
  "Lena",
  "Lianne",
  "Liesbeth",
  "Linda",
  "Lisanne",
  "Lisette",
  "Louise",
  "Maartje",
  "Manon",
  "Margot",
  "Marieke",
  "Marijke",
  "Marlies",
  "Marloes",
  "Marthe",
  "Melissa",
  "Michelle",
  "Nadine",
  "Natalie",
  "Nicole",
  "Nina",
  "Noortje",
  "Paulien",
  "Petra",
  "Rachel",
  "Renee",
  "Robin",
  "Rosa",
  "Roxanne",
  "Sabine",
  "Sandra",
  "Saskia",
  "Silke",
  "Simone",
  "Suzanne",
  "Sylvie",
  "Tamara",
  "Tanja",
  "Tara",
  "Thea",
  "Thirza",
  "Tina",
  "Tineke",
  "Ursula",
  "Victoria",
  "Wendy",
  "Wilma",
  "Xandra",
  "Yasmin",
  "Yvette",
  "Yvonne",
  "Zara"
];

// src/dictionaries/nl/lastnames.ts
var lastnames_default2 = [
  "de Jong",
  "Jansen",
  "de Vries",
  "van den Berg",
  "van Dijk",
  "Bakker",
  "Janssen",
  "Visser",
  "Smit",
  "Meijer",
  "de Boer",
  "Mulder",
  "de Groot",
  "Bos",
  "Vos",
  "Peters",
  "Hendriks",
  "van Leeuwen",
  "Dekker",
  "Brouwer",
  "de Wit",
  "Dijkstra",
  "Smits",
  "de Graaf",
  "van der Meer",
  "van der Linden",
  "Kok",
  "Jacobs",
  "de Haan",
  "Vermeulen",
  "van den Heuvel",
  "van der Veen",
  "van den Broek",
  "de Bruijn",
  "de Bruin",
  "van der Heijden",
  "Schouten",
  "van Beek",
  "Willems",
  "van Vliet",
  "van de Ven",
  "Hoekstra",
  "Maas",
  "Verhoeven",
  "Koster",
  "van Dam",
  "van der Wal",
  "Prins",
  "Blom",
  "Huisman",
  "Peeters",
  "Kuipers",
  "van Veen",
  "van Dongen",
  "Veenstra",
  "Kramer",
  "van den Bosch",
  "van der Meulen",
  "Mol",
  "Zwart",
  "van der Laan",
  "Martens",
  "van de Pol",
  "Postma",
  "Tromp",
  "Borst",
  "Boon",
  "van Doorn",
  "Jonker",
  "van der Velden",
  "Willemsen",
  "van Wijk",
  "Groen",
  "Gerritsen",
  "Bosch",
  "van Loon",
  "van der Ploeg",
  "de Ruiter",
  "Molenaar",
  "Boer",
  "Klein",
  "de Koning",
  "van de Kamp",
  "van der Horst",
  "Verbeek",
  "Vink",
  "Goossens",
  "Scholten",
  "Hartman",
  "van Dalen",
  "van Elst",
  "Brink",
  "Boekel",
  "van de Berg",
  "Berends",
  "van der Hoek",
  "Kuiper",
  "Kooijman",
  "de Lange",
  "van der Sluis",
  "van Gelder",
  "Martens",
  "van Asselt",
  "Timmermans",
  "van Vliet",
  "van Rijn",
  "van Schaik",
  "Bosman",
  "Wolters",
  "van Hout",
  "Hermans",
  "van Rooij",
  "de Vos",
  "van Donselaar",
  "Evers",
  "van den Brink",
  "Verkerk",
  "Groeneveld",
  "van Duijn",
  "Schuurman",
  "Hoogendoorn",
  "van Zanten",
  "Koopman",
  "Cornelissen",
  "van Driel",
  "Teunissen",
  "Versteeg",
  "van Deursen",
  "Schipper",
  "van Kempen",
  "Bouwman",
  "van der Valk",
  "Nijhuis",
  "van der Werf",
  "van den Akker",
  "Verhoef",
  "Wessels",
  "van der Poel",
  "Driessen",
  "van Oosten",
  "Lambrechts",
  "van der Vlist",
  "Hoogeveen",
  "van Gils",
  "Rietveld",
  "Barendrecht",
  "van der Spek",
  "Stam",
  "van der Linde",
  "Boersma",
  "van Dijk",
  "Schepers",
  "van der Kolk",
  "Roelofs",
  "van der Velden",
  "van den Burg",
  "Westra",
  "van der Steen",
  "Pronk",
  "van der Veer",
  "Rozendaal",
  "van den Bos",
  "Konings",
  "van der Wiel",
  "Noordam",
  "van der Laan",
  "Schut",
  "van der Vlugt",
  "Witteveen",
  "van der Zwan",
  "Boogaard",
  "van der Waal",
  "Stolk",
  "van der Windt",
  "Rutten",
  "van der Zanden",
  "Spaans",
  "van der Zwaan",
  "Roos",
  "van der Zijl",
  "Schoenmaker",
  "van Diepen",
  "Romeijn",
  "van Doesburg",
  "Schippers",
  "van Eck",
  "Rijken",
  "van Egmond",
  "Schrama",
  "van Eijk",
  "Ruijter",
  "van Engelen",
  "Sanders",
  "van Es",
  "Schenk",
  "van Essen",
  "van Gaal",
  "van Geenen",
  "van Gent",
  "van Gestel",
  "van Gool",
  "van Grinsven",
  "van Gurp",
  "van Haaften",
  "van Haren",
  "van Hattem",
  "van Hees"
];

// src/implementations/IdentityGeneratorNl.ts
var IdentityGeneratorNl = class extends IdentityGenerator {
  /**
   * Get the male first names.
   */
  getFirstNamesMaleJson() {
    return firstnames_male_default2;
  }
  /**
   * Get the female first names.
   */
  getFirstNamesFemaleJson() {
    return firstnames_female_default2;
  }
  /**
   * Get the last names.
   */
  getLastNamesJson() {
    return lastnames_default2;
  }
};

// src/utils/IdentityHelperUtils.ts
var IdentityHelperUtils = class {
  /**
   * Normalize a birth date for display.
   */
  static normalizeBirthDateForDisplay(birthDate) {
    if (!birthDate || birthDate.startsWith("0001-01-01")) {
      return "";
    }
    return birthDate.split(/[T ]/)[0];
  }
  /**
   * Normalize a birth date for database.
   */
  static normalizeBirthDateForDb(input) {
    if (!input || input.trim() === "") {
      return "0001-01-01T00:00:00.000Z";
    }
    const trimmed = input.trim().replace(" ", "T");
    const match = trimmed.match(/^(\d{4})-(\d{2})-(\d{2})[T ]?(\d{2}):?(\d{2}):?(\d{2})?$/);
    if (match) {
      const [_, y, m, d, h = "00", mi = "00", s = "00"] = match;
      return `${y}-${m}-${d}T${h}:${mi}:${s}.000Z`;
    }
    const parsedDate = new Date(trimmed);
    if (!isNaN(parsedDate.getTime())) {
      return parsedDate.toISOString();
    }
    return "0001-01-01T00:00:00.000Z";
  }
  /**
   * Check if a birth date is valid.
   */
  static isValidBirthDate(input) {
    if (!input || input.trim() === "") {
      return false;
    }
    if (input.startsWith("0001-01-01")) {
      return false;
    }
    const date = new Date(input);
    if (isNaN(date.getTime())) {
      return false;
    }
    const yearValid = date.getFullYear() > 1 && date.getFullYear() < 9999;
    return yearValid;
  }
};

// src/factories/IdentityGeneratorFactory.ts
var CreateIdentityGenerator = (language) => {
  switch (language) {
    case "en":
      return new IdentityGeneratorEn();
    case "nl":
      return new IdentityGeneratorNl();
  }
  throw new Error(`Unsupported language: ${language}`);
};

// src/factories/UsernameEmailGeneratorFactory.ts
var CreateUsernameEmailGenerator = () => {
  return new UsernameEmailGenerator();
};
export {
  CreateIdentityGenerator,
  CreateUsernameEmailGenerator,
  Gender,
  IdentityGenerator,
  IdentityGeneratorEn,
  IdentityGeneratorNl,
  IdentityHelperUtils,
  UsernameEmailGenerator
};
//# sourceMappingURL=index.mjs.map