// <auto-generated>
// This file was automatically generated. Do not edit manually.

"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  CreateIdentityGenerator: () => CreateIdentityGenerator,
  CreateUsernameEmailGenerator: () => CreateUsernameEmailGenerator,
  Gender: () => Gender,
  IdentityGenerator: () => IdentityGenerator,
  IdentityGeneratorDe: () => IdentityGeneratorDe,
  IdentityGeneratorEn: () => IdentityGeneratorEn,
  IdentityGeneratorNl: () => IdentityGeneratorNl,
  IdentityHelperUtils: () => IdentityHelperUtils,
  UsernameEmailGenerator: () => UsernameEmailGenerator,
  convertAgeRangeToBirthdateOptions: () => convertAgeRangeToBirthdateOptions,
  getAvailableAgeRanges: () => getAvailableAgeRanges,
  getAvailableLanguages: () => getAvailableLanguages,
  mapUiLanguageToIdentityLanguage: () => mapUiLanguageToIdentityLanguage
});
module.exports = __toCommonJS(index_exports);

// src/types/Gender.ts
var Gender = /* @__PURE__ */ ((Gender2) => {
  Gender2["Male"] = "Male";
  Gender2["Female"] = "Female";
  Gender2["Other"] = "Other";
  return Gender2;
})(Gender || {});

// src/utils/UsernameEmailGenerator.ts
var _UsernameEmailGenerator = class _UsernameEmailGenerator {
  constructor() {
    this.symbols = [".", "-"];
  }
  /**
   * Generate a username based on an identity.
   */
  generateUsername(identity) {
    let username = this.generateEmailPrefix(identity);
    username = username.replace(/[^a-zA-Z0-9]/g, "");
    if (username.length < _UsernameEmailGenerator.MIN_LENGTH) {
      username += this.generateRandomString(_UsernameEmailGenerator.MIN_LENGTH - username.length);
    } else if (username.length > _UsernameEmailGenerator.MAX_LENGTH) {
      username = username.substring(0, _UsernameEmailGenerator.MAX_LENGTH);
    }
    return username;
  }
  /**
   * Generate an email prefix based on an identity.
   */
  generateEmailPrefix(identity) {
    const parts = [];
    if (typeof identity.birthDate === "string") {
      identity.birthDate = new Date(identity.birthDate);
    }
    switch (this.getSecureRandom(4)) {
      case 0:
        parts.push(identity.firstName.substring(0, 1).toLowerCase() + identity.lastName.toLowerCase());
        break;
      case 1:
        parts.push((identity.firstName + identity.lastName).toLowerCase());
        break;
      case 2:
        parts.push(identity.firstName.toLowerCase() + identity.lastName.substring(0, 1).toLowerCase());
        break;
      case 3:
        parts.push(identity.firstName.substring(0, Math.min(3, identity.firstName.length)).toLowerCase() + identity.lastName.toLowerCase());
        break;
    }
    switch (this.getSecureRandom(2)) {
      case 0:
        parts.push(identity.birthDate.getFullYear().toString());
        break;
      case 1:
        parts.push(identity.birthDate.getFullYear().toString().substring(2));
        break;
    }
    let emailPrefix = parts.join(this.getRandomSymbol());
    if (this.getSecureRandom(2) === 0) {
      const position = this.getSecureRandom(emailPrefix.length);
      emailPrefix = emailPrefix.slice(0, position) + this.getRandomSymbol() + emailPrefix.slice(position);
    }
    emailPrefix = this.sanitizeEmailPrefix(emailPrefix);
    if (emailPrefix.length < _UsernameEmailGenerator.MIN_LENGTH) {
      emailPrefix += this.generateRandomString(_UsernameEmailGenerator.MIN_LENGTH - emailPrefix.length);
    } else if (emailPrefix.length > _UsernameEmailGenerator.MAX_LENGTH) {
      emailPrefix = emailPrefix.substring(0, _UsernameEmailGenerator.MAX_LENGTH);
    }
    return emailPrefix;
  }
  /**
   * Sanitize an email prefix.
   */
  sanitizeEmailPrefix(input) {
    let sanitized = input.replace(/[^a-zA-Z0-9._-]/g, "");
    sanitized = sanitized.replace(/[-_.]{2,}/g, (match) => match[0]);
    sanitized = sanitized.replace(/^[-._]+/, "");
    sanitized = sanitized.replace(/[-._]*$/, "");
    return sanitized;
  }
  /**
   * Get a random symbol.
   */
  getRandomSymbol() {
    return this.getSecureRandom(3) === 0 ? this.symbols[this.getSecureRandom(this.symbols.length)] : "";
  }
  /**
   * Generate a random string.
   */
  generateRandomString(length) {
    const chars = "abcdefghijklmnopqrstuvwxyz0123456789";
    return Array.from({ length }, () => chars.charAt(this.getSecureRandom(chars.length))).join("");
  }
  /**
   * Generate a secure random integer between 0 (inclusive) and max (exclusive)
   */
  getSecureRandom(max) {
    const array = new Uint32Array(1);
    crypto.getRandomValues(array);
    return array[0] % max;
  }
};
_UsernameEmailGenerator.MIN_LENGTH = 6;
_UsernameEmailGenerator.MAX_LENGTH = 20;
var UsernameEmailGenerator = _UsernameEmailGenerator;

// src/implementations/base/IdentityGenerator.ts
var IdentityGenerator = class {
  /**
   * Constructor.
   */
  constructor() {
    this.firstNamesMale = [];
    this.firstNamesFemale = [];
    this.lastNames = [];
    this.random = Math.random;
    this.firstNamesMale = this.getFirstNamesMaleJson();
    this.firstNamesFemale = this.getFirstNamesFemaleJson();
    this.lastNames = this.getLastNamesJson();
  }
  /**
   * Get decade-based male first names. Override this to provide age-specific names.
   * If not overridden, returns an empty array and falls back to generic names.
   */
  getFirstNamesMaleByDecade() {
    return [];
  }
  /**
   * Get decade-based female first names. Override this to provide age-specific names.
   * If not overridden, returns an empty array and falls back to generic names.
   */
  getFirstNamesFemaleByDecade() {
    return [];
  }
  /**
   * Generate a random date of birth.
   * @param birthdateOptions Optional birthdate configuration
   */
  generateRandomDateOfBirth(birthdateOptions) {
    if (birthdateOptions) {
      const { targetYear, yearDeviation } = birthdateOptions;
      if (yearDeviation === 0) {
        const startOfYear = new Date(targetYear, 0, 1);
        const endOfYear = new Date(targetYear, 11, 31);
        const timestamp2 = startOfYear.getTime() + this.random() * (endOfYear.getTime() - startOfYear.getTime());
        return new Date(timestamp2);
      } else {
        const minYear = targetYear - yearDeviation;
        const maxYear = targetYear + yearDeviation;
        const startDate = new Date(minYear, 0, 1);
        const endDate = new Date(maxYear, 11, 31);
        const timestamp2 = startDate.getTime() + this.random() * (endDate.getTime() - startDate.getTime());
        return new Date(timestamp2);
      }
    }
    const today = /* @__PURE__ */ new Date();
    const minAge = 21;
    const maxAge = 65;
    const minDate = new Date(today.getFullYear() - maxAge, today.getMonth(), today.getDate());
    const maxDate = new Date(today.getFullYear() - minAge, today.getMonth(), today.getDate());
    const timestamp = minDate.getTime() + this.random() * (maxDate.getTime() - minDate.getTime());
    return new Date(timestamp);
  }
  /**
   * Select appropriate firstnames based on birthdate.
   * Falls back to generic names if no decade-specific data is available.
   */
  selectFirstnamesForBirthdate(birthdate, isMale) {
    const birthYear = birthdate.getFullYear();
    const decadeData = isMale ? this.getFirstNamesMaleByDecade() : this.getFirstNamesFemaleByDecade();
    if (decadeData.length === 0) {
      return isMale ? this.firstNamesMale : this.firstNamesFemale;
    }
    const matchingRanges = decadeData.filter(
      (range) => birthYear >= range.startYear && birthYear <= range.endYear
    );
    if (matchingRanges.length > 0) {
      const combinedNames = [];
      matchingRanges.forEach((range) => combinedNames.push(...range.names));
      return combinedNames;
    }
    const allDecadeNames = [];
    decadeData.forEach((range) => allDecadeNames.push(...range.names));
    if (allDecadeNames.length > 0) {
      return allDecadeNames;
    }
    return isMale ? this.firstNamesMale : this.firstNamesFemale;
  }
  /**
   * Generate a random identity.
   */
  generateRandomIdentity(gender, birthdateOptions) {
    const identity = {
      firstName: "",
      lastName: "",
      gender: "Male" /* Male */,
      birthDate: /* @__PURE__ */ new Date(),
      emailPrefix: "",
      nickName: ""
    };
    let selectedGender;
    if (gender === "random" || gender === void 0) {
      selectedGender = this.random() < 0.5 ? "Male" /* Male */ : "Female" /* Female */;
    } else {
      if (gender === "male") {
        selectedGender = "Male" /* Male */;
      } else if (gender === "female") {
        selectedGender = "Female" /* Female */;
      } else {
        selectedGender = "Male" /* Male */;
      }
    }
    identity.gender = selectedGender;
    identity.birthDate = this.generateRandomDateOfBirth(birthdateOptions);
    let availableFirstnames;
    if (selectedGender === "Male" /* Male */) {
      availableFirstnames = this.selectFirstnamesForBirthdate(identity.birthDate, true);
    } else if (selectedGender === "Female" /* Female */) {
      availableFirstnames = this.selectFirstnamesForBirthdate(identity.birthDate, false);
    } else {
      const usesMaleNames = this.random() < 0.5;
      availableFirstnames = this.selectFirstnamesForBirthdate(identity.birthDate, usesMaleNames);
    }
    identity.firstName = availableFirstnames[Math.floor(this.random() * availableFirstnames.length)];
    identity.lastName = this.lastNames[Math.floor(this.random() * this.lastNames.length)];
    const generator = new UsernameEmailGenerator();
    identity.emailPrefix = generator.generateEmailPrefix(identity);
    identity.nickName = generator.generateUsername(identity);
    return identity;
  }
};

// src/dictionaries/en/firstnames_male.ts
var firstnames_male_default = [
  "Aaron",
  "Adam",
  "Adrian",
  "Aidan",
  "Aiden",
  "Alan",
  "Albert",
  "Alex",
  "Alexander",
  "Alfred",
  "Amir",
  "Andrew",
  "Anthony",
  "Antonio",
  "Archer",
  "Arthur",
  "Asher",
  "Austin",
  "Axel",
  "Barry",
  "Beau",
  "Beckett",
  "Benjamin",
  "Bennett",
  "Bernard",
  "Blake",
  "Braden",
  "Bradley",
  "Brady",
  "Brandon",
  "Braxton",
  "Brayden",
  "Brendan",
  "Brett",
  "Brian",
  "Bruce",
  "Bryan",
  "Bryce",
  "Bryson",
  "Caden",
  "Caleb",
  "Calvin",
  "Camden",
  "Cameron",
  "Carlos",
  "Carson",
  "Carter",
  "Casey",
  "Cecil",
  "Charles",
  "Chase",
  "Chester",
  "Christian",
  "Christopher",
  "Clarence",
  "Claude",
  "Clifford",
  "Clyde",
  "Cody",
  "Cole",
  "Colin",
  "Collin",
  "Colton",
  "Connor",
  "Cooper",
  "Corey",
  "Craig",
  "Curtis",
  "Dakota",
  "Dale",
  "Dalton",
  "Damian",
  "Dan",
  "Daniel",
  "Darrell",
  "Daryl",
  "David",
  "Dawson",
  "Dean",
  "Declan",
  "Dennis",
  "Derek",
  "Devin",
  "Dominic",
  "Dominick",
  "Don",
  "Douglas",
  "Dustin",
  "Dylan",
  "Earl",
  "Easton",
  "Edgar",
  "Edmund",
  "Edward",
  "Edwin",
  "Eli",
  "Elias",
  "Elijah",
  "Elliot",
  "Elliott",
  "Emilio",
  "Emmett",
  "Eric",
  "Ethan",
  "Eugene",
  "Evan",
  "Everett",
  "Felix",
  "Ferdinand",
  "Floyd",
  "Forrest",
  "Francis",
  "Franklin",
  "Frederick",
  "Gabriel",
  "Gael",
  "Garrett",
  "Gary",
  "Gavin",
  "George",
  "Gerald",
  "Gilbert",
  "Glen",
  "Gordon",
  "Graham",
  "Grant",
  "Grayson",
  "Gregory",
  "Greyson",
  "Harold",
  "Harrison",
  "Harvey",
  "Hayden",
  "Henry",
  "Herman",
  "Howard",
  "Hudson",
  "Hugh",
  "Hugo",
  "Hunter",
  "Ian",
  "Irving",
  "Isaac",
  "Isaiah",
  "Ivan",
  "Jace",
  "Jack",
  "Jackson",
  "Jacob",
  "Jaden",
  "James",
  "Jared",
  "Jason",
  "Jasper",
  "Jayden",
  "Jeffrey",
  "Jeremiah",
  "Jeremy",
  "Jerome",
  "Jesse",
  "Jesus",
  "Joel",
  "John",
  "Jonathan",
  "Jordan",
  "Jorge",
  "Jose",
  "Joseph",
  "Joshua",
  "Josiah",
  "Juan",
  "Justin",
  "Kai",
  "Kayden",
  "Keith",
  "Kenneth",
  "Kevin",
  "Kingston",
  "Knox",
  "Kyle",
  "Landon",
  "Lawrence",
  "Leo",
  "Leon",
  "Leonard",
  "Leonardo",
  "Leslie",
  "Levi",
  "Liam",
  "Lincoln",
  "Lloyd",
  "Logan",
  "Luca",
  "Lucas",
  "Luis",
  "Luke",
  "Maddox",
  "Malachi",
  "Malcolm",
  "Marcus",
  "Mark",
  "Martin",
  "Marvin",
  "Mason",
  "Mateo",
  "Matthew",
  "Maurice",
  "Max",
  "Maxwell",
  "Micah",
  "Michael",
  "Miguel",
  "Miles",
  "Milton",
  "Mitchell",
  "Morris",
  "Nathan",
  "Nathaniel",
  "Neil",
  "Nelson",
  "Nicholas",
  "Noah",
  "Nolan",
  "Norman",
  "Oliver",
  "Oscar",
  "Owen",
  "Parker",
  "Patrick",
  "Paul",
  "Perry",
  "Peter",
  "Philip",
  "Phillip",
  "Preston",
  "Ralph",
  "Randy",
  "Ray",
  "Raymond",
  "Rhett",
  "Richard",
  "Riley",
  "Robert",
  "Roderick",
  "Rodney",
  "Roger",
  "Roland",
  "Roman",
  "Ronald",
  "Ross",
  "Roy",
  "Russell",
  "Ryan",
  "Ryder",
  "Ryker",
  "Samuel",
  "Sawyer",
  "Scott",
  "Sean",
  "Sebastian",
  "Seth",
  "Shane",
  "Shawn",
  "Silas",
  "Simon",
  "Spencer",
  "Stanley",
  "Stephen",
  "Steven",
  "Stuart",
  "Tanner",
  "Terrence",
  "Theodore",
  "Thomas",
  "Timothy",
  "Travis",
  "Trevor",
  "Tristan",
  "Tyler",
  "Vernon",
  "Victor",
  "Vincent",
  "Wade",
  "Wallace",
  "Walter",
  "Warren",
  "Wayne",
  "Wendell",
  "Wesley",
  "Weston",
  "William",
  "Winston",
  "Wyatt",
  "Xavier",
  "Zachariah",
  "Zachary",
  "Zane"
];

// src/dictionaries/en/firstnames_female.ts
var firstnames_female_default = [
  "Aaliyah",
  "Abigail",
  "Ada",
  "Adalyn",
  "Adalynn",
  "Addison",
  "Adeline",
  "Adriana",
  "Alexa",
  "Alexandra",
  "Alice",
  "Alina",
  "Allison",
  "Alyssa",
  "Amara",
  "Amaya",
  "Amelia",
  "Anastasia",
  "Andrea",
  "Anna",
  "Annabelle",
  "Aria",
  "Ariana",
  "Arianna",
  "Arielle",
  "Arya",
  "Ashley",
  "Aspen",
  "Athena",
  "Aubree",
  "Aubrey",
  "Audrey",
  "Aurora",
  "Autumn",
  "Ava",
  "Avery",
  "Ayla",
  "Bailey",
  "Beatrice",
  "Bella",
  "Bianca",
  "Blair",
  "Brianna",
  "Brielle",
  "Brooklyn",
  "Brynn",
  "Calliope",
  "Camila",
  "Camille",
  "Carmen",
  "Caroline",
  "Cassidy",
  "Catalina",
  "Cecilia",
  "Celeste",
  "Charlie",
  "Charlotte",
  "Chloe",
  "Claire",
  "Clara",
  "Cora",
  "Coraline",
  "Dahlia",
  "Daisy",
  "Dakota",
  "Daphne",
  "Dawn",
  "Delilah",
  "Diana",
  "Eden",
  "Eleanor",
  "Elena",
  "Eliana",
  "Elise",
  "Eliza",
  "Elizabeth",
  "Ella",
  "Ellie",
  "Eloise",
  "Ember",
  "Emerson",
  "Emersyn",
  "Emery",
  "Emilia",
  "Emily",
  "Emma",
  "Esme",
  "Esther",
  "Eva",
  "Evangeline",
  "Evelyn",
  "Everly",
  "Faith",
  "Fiona",
  "Flora",
  "Florence",
  "Francesca",
  "Freya",
  "Gabriella",
  "Gemma",
  "Genesis",
  "Georgia",
  "Gianna",
  "Giselle",
  "Grace",
  "Gwendolyn",
  "Hadley",
  "Hailey",
  "Hannah",
  "Harlow",
  "Harmony",
  "Harper",
  "Haven",
  "Hazel",
  "Heidi",
  "Helena",
  "Holly",
  "Hope",
  "Imogen",
  "India",
  "Indie",
  "Iris",
  "Isabel",
  "Isabella",
  "Isabelle",
  "Isla",
  "Ivy",
  "Jade",
  "Jasmine",
  "Jessie",
  "Jocelyn",
  "Josephine",
  "Josie",
  "Julia",
  "Juliana",
  "Juliet",
  "June",
  "Juniper",
  "Kaia",
  "Katherine",
  "Kayla",
  "Kaylee",
  "Keira",
  "Kennedy",
  "Khloe",
  "Kinsley",
  "Kylie",
  "Lara",
  "Laura",
  "Laurel",
  "Layla",
  "Leah",
  "Leilani",
  "Lena",
  "Liliana",
  "Lillian",
  "Lily",
  "Lola",
  "Lorelei",
  "Lucia",
  "Lucy",
  "Luna",
  "Lydia",
  "Lyla",
  "Mabel",
  "Mackenzie",
  "Madeline",
  "Madelyn",
  "Madison",
  "Maeve",
  "Magnolia",
  "Maisie",
  "Malia",
  "Margaret",
  "Margot",
  "Maria",
  "Marina",
  "Marlowe",
  "Mary",
  "Matilda",
  "Maya",
  "Melanie",
  "Melody",
  "Mia",
  "Mira",
  "Miranda",
  "Morgan",
  "Nadia",
  "Naomi",
  "Natalia",
  "Natalie",
  "Nell",
  "Nevaeh",
  "Nina",
  "Noelle",
  "Nora",
  "Norah",
  "Nova",
  "Octavia",
  "Odette",
  "Olive",
  "Olivia",
  "Opal",
  "Ophelia",
  "Paisley",
  "Pearl",
  "Penelope",
  "Peyton",
  "Phoebe",
  "Phoenix",
  "Piper",
  "Poppy",
  "Primrose",
  "Quinn",
  "Raelynn",
  "Ramona",
  "Raven",
  "Reagan",
  "Reese",
  "Riley",
  "River",
  "Robin",
  "Rosalie",
  "Rose",
  "Rosemary",
  "Rowan",
  "Ruby",
  "Ruth",
  "Rylee",
  "Ryleigh",
  "Sabrina",
  "Sadie",
  "Sage",
  "Salem",
  "Samantha",
  "Sarah",
  "Sasha",
  "Savannah",
  "Scarlett",
  "Selena",
  "Serena",
  "Serenity",
  "Sienna",
  "Sierra",
  "Simone",
  "Skye",
  "Skylar",
  "Sloane",
  "Sofia",
  "Sophia",
  "Sophie",
  "Stella",
  "Summer",
  "Sylvia",
  "Sylvie",
  "Talia",
  "Taylor",
  "Tessa",
  "Thea",
  "Thora",
  "Valentina",
  "Valeria",
  "Vera",
  "Victoria",
  "Violet",
  "Vivian",
  "Vivienne",
  "Willa",
  "Willow",
  "Winnie",
  "Winter",
  "Wren",
  "Ximena",
  "Yara",
  "Zara",
  "Zoe",
  "Zoey"
];

// src/dictionaries/en/lastnames.ts
var lastnames_default = [
  "Abbott",
  "Adams",
  "Aguilar",
  "Alexander",
  "Allen",
  "Alvarez",
  "Anderson",
  "Atkins",
  "Bailey",
  "Baker",
  "Baldwin",
  "Ballard",
  "Barber",
  "Barker",
  "Barnes",
  "Barrett",
  "Bauer",
  "Baxter",
  "Beard",
  "Bell",
  "Bennett",
  "Benson",
  "Black",
  "Blackwood",
  "Blake",
  "Blanchard",
  "Booth",
  "Bowman",
  "Bradley",
  "Briggs",
  "Brooks",
  "Brown",
  "Bryant",
  "Buckley",
  "Burke",
  "Burns",
  "Butler",
  "Byrd",
  "Cain",
  "Campbell",
  "Cannon",
  "Carlson",
  "Carter",
  "Castillo",
  "Castro",
  "Chandler",
  "Chapman",
  "Chavez",
  "Chen",
  "Clark",
  "Clarke",
  "Cobb",
  "Cole",
  "Coleman",
  "Collier",
  "Collins",
  "Conrad",
  "Cook",
  "Cooke",
  "Cooper",
  "Cox",
  "Craig",
  "Crawford",
  "Cross",
  "Cruz",
  "Cunningham",
  "Dalton",
  "Daniel",
  "Davenport",
  "Davis",
  "Dawson",
  "Dempsey",
  "Dennis",
  "Diaz",
  "Dickerson",
  "Dillon",
  "Dixon",
  "Doyle",
  "Duran",
  "Dyer",
  "Edwards",
  "Ellis",
  "Erickson",
  "Evans",
  "Ewing",
  "Farley",
  "Farr",
  "Farrell",
  "Fernandez",
  "Ferris",
  "Fisher",
  "Fitzgerald",
  "Fleming",
  "Fletcher",
  "Flores",
  "Foley",
  "Ford",
  "Foster",
  "Fowler",
  "Frazier",
  "Freeman",
  "Frost",
  "Fuller",
  "Gallagher",
  "Garcia",
  "Gardner",
  "Garner",
  "Garrett",
  "Gates",
  "Gibbs",
  "Gibson",
  "Gill",
  "Glover",
  "Goldberg",
  "Gomez",
  "Gonzales",
  "Gonzalez",
  "Goodman",
  "Goodwin",
  "Gordon",
  "Graham",
  "Graves",
  "Gray",
  "Green",
  "Griffin",
  "Griffith",
  "Gross",
  "Gutierrez",
  "Guzman",
  "Hale",
  "Hall",
  "Hamilton",
  "Hancock",
  "Harmon",
  "Harris",
  "Harrison",
  "Hawkins",
  "Hayes",
  "Hayward",
  "Henderson",
  "Hendricks",
  "Henry",
  "Hensley",
  "Hernandez",
  "Herrera",
  "Hicks",
  "Hill",
  "Hodges",
  "Holland",
  "Holmes",
  "Holt",
  "Hoover",
  "Howard",
  "Hudson",
  "Huffman",
  "Hughes",
  "Humphrey",
  "Hunter",
  "Hutchinson",
  "Isaac",
  "Jackson",
  "Jacobson",
  "James",
  "Jarvis",
  "Jenkins",
  "Jimenez",
  "Johnson",
  "Jones",
  "Jordan",
  "Keller",
  "Kelly",
  "Kennedy",
  "Kent",
  "Kerr",
  "Kim",
  "King",
  "Kirby",
  "Knowles",
  "Koch",
  "Landry",
  "Lang",
  "Lawson",
  "Lee",
  "Levy",
  "Lewis",
  "Livingston",
  "Logan",
  "Long",
  "Lopez",
  "Lowery",
  "Lowry",
  "Lucas",
  "Luna",
  "Malone",
  "Manning",
  "Marsh",
  "Marshall",
  "Martin",
  "Martinez",
  "Mason",
  "May",
  "McBride",
  "McCoy",
  "McDonald",
  "McKinney",
  "Mccarthy",
  "Mcguire",
  "Mckay",
  "Mckenzie",
  "Meadows",
  "Medina",
  "Mendez",
  "Mendoza",
  "Middleton",
  "Miller",
  "Miranda",
  "Mitchell",
  "Moody",
  "Moore",
  "Morales",
  "Moreno",
  "Morgan",
  "Morris",
  "Morse",
  "Murphy",
  "Murray",
  "Myers",
  "Nash",
  "Neal",
  "Nelson",
  "Nguyen",
  "Nichols",
  "Nielsen",
  "Nixon",
  "Norton",
  "Olson",
  "Orr",
  "Ortiz",
  "Owens",
  "Palmer",
  "Parker",
  "Parsons",
  "Patel",
  "Patterson",
  "Payne",
  "Pearce",
  "Pearson",
  "Perez",
  "Perry",
  "Peterson",
  "Phillips",
  "Pickett",
  "Pollard",
  "Porter",
  "Potter",
  "Powell",
  "Pratt",
  "Preston",
  "Price",
  "Ramirez",
  "Ramos",
  "Randall",
  "Ray",
  "Reed",
  "Reyes",
  "Reynolds",
  "Richardson",
  "Riddle",
  "Riley",
  "Rivera",
  "Roach",
  "Robbins",
  "Roberts",
  "Robinson",
  "Rodriguez",
  "Rogers",
  "Romero",
  "Ross",
  "Rowe",
  "Ruiz",
  "Russell",
  "Salinas",
  "Sanchez",
  "Sanders",
  "Santana",
  "Savage",
  "Sawyer",
  "Schmidt",
  "Schultz",
  "Scott",
  "Sellers",
  "Shannon",
  "Sharp",
  "Shaw",
  "Shepherd",
  "Shields",
  "Short",
  "Silva",
  "Simmons",
  "Simpson",
  "Skinner",
  "Sloan",
  "Smith",
  "Snyder",
  "Sparks",
  "Spears",
  "Stanley",
  "Stark",
  "Steele",
  "Stephenson",
  "Stevens",
  "Stewart",
  "Stokes",
  "Sullivan",
  "Sutton",
  "Swanson",
  "Tanner",
  "Tate",
  "Taylor",
  "Thomas",
  "Thompson",
  "Thornton",
  "Torres",
  "Tran",
  "Travis",
  "Tucker",
  "Turner",
  "Tyler",
  "Underwood",
  "Vargas",
  "Vasquez",
  "Vincent",
  "Wagner",
  "Walker",
  "Wallace",
  "Walters",
  "Walton",
  "Ward",
  "Washington",
  "Watkins",
  "Watson",
  "Weaver",
  "Webb",
  "Weeks",
  "Welch",
  "Wells",
  "West",
  "Whitaker",
  "White",
  "Wilcox",
  "Wilkinson",
  "Williams",
  "Willis",
  "Wilson",
  "Winters",
  "Wise",
  "Wolfe",
  "Wood",
  "Woods",
  "Woodward",
  "Wright",
  "Wyatt",
  "Yates",
  "York",
  "Young",
  "Zamora",
  "Zimmerman"
];

// src/implementations/IdentityGeneratorEn.ts
var IdentityGeneratorEn = class extends IdentityGenerator {
  /**
   * Get the male first names.
   */
  getFirstNamesMaleJson() {
    return firstnames_male_default;
  }
  /**
   * Get the female first names.
   */
  getFirstNamesFemaleJson() {
    return firstnames_female_default;
  }
  /**
   * Get the last names.
   */
  getLastNamesJson() {
    return lastnames_default;
  }
};

// src/dictionaries/nl/firstnames_male.ts
var firstnames_male_default2 = [
  "Daan",
  "Luuk",
  "Sem",
  "Finn",
  "Milan",
  "Levi",
  "Noah",
  "Lucas",
  "Jesse",
  "Thijs",
  "Jayden",
  "Bram",
  "Lars",
  "Ruben",
  "Thomas",
  "Tim",
  "Sam",
  "Liam",
  "Julian",
  "Mees",
  "Ties",
  "Sven",
  "Max",
  "Gijs",
  "David",
  "Stijn",
  "Jasper",
  "Niels",
  "Jens",
  "Timo",
  "Cas",
  "Joep",
  "Roan",
  "Tom",
  "Tygo",
  "Teun",
  "Siem",
  "Mats",
  "Thijmen",
  "Rens",
  "Niek",
  "Tobias",
  "Dex",
  "Hugo",
  "Robin",
  "Nick",
  "Floris",
  "Pepijn",
  "Boaz",
  "Olivier",
  "Luca",
  "Jurre",
  "Jelle",
  "Guus",
  "Koen",
  "Bart",
  "Olaf",
  "Wessel",
  "Dani\xEBl",
  "Job",
  "Sander",
  "Tijmen",
  "Kai",
  "Quinten",
  "Owen",
  "Morris",
  "Fedde",
  "Joris",
  "Jesper",
  "Mick",
  "Ryan",
  "Milo",
  "Stan",
  "Benjamin",
  "Melle",
  "Jip",
  "Dylan",
  "Brent",
  "Mick",
  "Dean",
  "Otis",
  "Abel",
  "Luc",
  "Sepp",
  "Vince",
  "Rayan",
  "Noud",
  "Hidde",
  "Fabian",
  "Jort",
  "Damian",
  "Boris",
  "Sil",
  "Moos",
  "Aiden",
  "Sep",
  "Mika",
  "Mijs",
  "Mika",
  "Felix",
  "Merlijn",
  "Alexander",
  "Aron",
  "Arthur",
  "Axel",
  "Bas",
  "Bastiaan",
  "Berend",
  "Bj\xF6rn",
  "Casper",
  "Cees",
  "Chris",
  "Christian",
  "Christiaan",
  "Colin",
  "Cornelis",
  "Dani",
  "Dennis",
  "Dirk",
  "Dominic",
  "Eduard",
  "Eelco",
  "Erik",
  "Erwin",
  "Ezra",
  "Faas",
  "Filip",
  "Florian",
  "Frank",
  "Frederik",
  "Freek",
  "Gerard",
  "Gerrit",
  "Giel",
  "Gijs",
  "Glenn",
  "Govert",
  "Harm",
  "Harold",
  "Hendrik",
  "Henrik",
  "Huub",
  "Ian",
  "Ivo",
  "Jacob",
  "Jake",
  "Jan",
  "Jarno",
  "Jason",
  "Jeffrey",
  "Jeremy",
  "Jim",
  "Jimmy",
  "Johan",
  "Johannes",
  "Jonas",
  "Jonathan",
  "Jos",
  "Joshua",
  "Justin",
  "Kay",
  "Kevin",
  "Kjeld",
  "Klaas",
  "Lennard",
  "Lennart",
  "Leon",
  "Lex",
  "Liam",
  "Loek",
  "Lorenzo",
  "Louis",
  "Lowie",
  "Maarten",
  "Magnus",
  "Maikel",
  "Marc",
  "Marcel",
  "Marco",
  "Martijn",
  "Mathias",
  "Matthijs",
  "Maurits",
  "Menno",
  "Michiel",
  "Nathan",
  "Nico",
  "Oscar",
  "Pascal",
  "Patrick",
  "Paul",
  "Peter",
  "Philip",
  "Pieter",
  "Pim",
  "Quincy",
  "Remco",
  "Rick",
  "Rik",
  "Robert",
  "Rogier",
  "Rowan",
  "Ruud",
  "Simon",
  "Stefan",
  "Steven",
  "Thom",
  "Victor",
  "Vincent",
  "Willem",
  "Wouter",
  "Yannick"
];

// src/dictionaries/nl/firstnames_female.ts
var firstnames_female_default2 = [
  "Emma",
  "Sophie",
  "Julia",
  "Mila",
  "Tess",
  "Sara",
  "Anna",
  "Noor",
  "Lotte",
  "Liv",
  "Eva",
  "Nora",
  "Zo\xEB",
  "Evi",
  "Yara",
  "Saar",
  "Nina",
  "Fenna",
  "Lieke",
  "Fleur",
  "Isa",
  "Roos",
  "Lynn",
  "Sofie",
  "Sarah",
  "Milou",
  "Olivia",
  "Maud",
  "Lisa",
  "Vera",
  "Luna",
  "Lina",
  "Noa",
  "Feline",
  "Lo\xEFs",
  "Lena",
  "Floor",
  "Charlotte",
  "Esmee",
  "Julie",
  "Iris",
  "Lara",
  "Amber",
  "Hailey",
  "Mia",
  "Lize",
  "Isabelle",
  "Cato",
  "Fenne",
  "Sanne",
  "Norah",
  "Sophia",
  "Ella",
  "Nova",
  "Elin",
  "Femke",
  "Lizzy",
  "Linde",
  "Lauren",
  "Rosalie",
  "Lana",
  "Emily",
  "Elise",
  "Esm\xE9e",
  "Anne",
  "Isabelle",
  "Demi",
  "Hannah",
  "Liva",
  "Suze",
  "Fay",
  "Isabel",
  "Benthe",
  "Evi",
  "Amy",
  "Jasmijn",
  "Niene",
  "Sterre",
  "Fenna",
  "Fiene",
  "Liz",
  "Ise",
  "Mara",
  "Nienke",
  "Indy",
  "Romy",
  "Lola",
  "Puck",
  "Nora",
  "Merel",
  "Bente",
  "Eline",
  "Lily",
  "Leah",
  "Naomi",
  "Mirthe",
  "Valerie",
  "Noor",
  "Liva",
  "Jade",
  "Juul",
  "Lise",
  "Myrthe",
  "Veerle",
  "Aafke",
  "Alicia",
  "Amira",
  "Aniek",
  "Annabel",
  "Annelies",
  "Anouk",
  "Astrid",
  "Babette",
  "Bianca",
  "Britt",
  "Carlijn",
  "Chantal",
  "Claire",
  "Dagmar",
  "Danique",
  "Daphne",
  "Denise",
  "Dominique",
  "Doris",
  "Eefje",
  "Elena",
  "Eline",
  "Elisa",
  "Elisabeth",
  "Ellen",
  "Esther",
  "Eveline",
  "Fabienne",
  "Felice",
  "Fleur",
  "Frederique",
  "Gwen",
  "Hanna",
  "Heleen",
  "Helena",
  "Ilona",
  "Imke",
  "Inge",
  "Irene",
  "Iris",
  "Janna",
  "Janneke",
  "Jasmine",
  "Jennifer",
  "Jessica",
  "Joelle",
  "Judith",
  "Julia",
  "Karin",
  "Karlijn",
  "Kim",
  "Kirsten",
  "Kyra",
  "Laura",
  "Lena",
  "Lianne",
  "Liesbeth",
  "Linda",
  "Lisanne",
  "Lisette",
  "Louise",
  "Maartje",
  "Manon",
  "Margot",
  "Marieke",
  "Marijke",
  "Marlies",
  "Marloes",
  "Marthe",
  "Melissa",
  "Michelle",
  "Nadine",
  "Natalie",
  "Nicole",
  "Nina",
  "Noortje",
  "Paulien",
  "Petra",
  "Rachel",
  "Renee",
  "Robin",
  "Rosa",
  "Roxanne",
  "Sabine",
  "Sandra",
  "Saskia",
  "Silke",
  "Simone",
  "Suzanne",
  "Sylvie",
  "Tamara",
  "Tanja",
  "Tara",
  "Thea",
  "Thirza",
  "Tina",
  "Tineke",
  "Ursula",
  "Victoria",
  "Wendy",
  "Wilma",
  "Xandra",
  "Yasmin",
  "Yvette",
  "Yvonne",
  "Zara"
];

// src/dictionaries/nl/lastnames.ts
var lastnames_default2 = [
  "de Jong",
  "Jansen",
  "de Vries",
  "van den Berg",
  "van Dijk",
  "Bakker",
  "Janssen",
  "Visser",
  "Smit",
  "Meijer",
  "de Boer",
  "Mulder",
  "de Groot",
  "Bos",
  "Vos",
  "Peters",
  "Hendriks",
  "van Leeuwen",
  "Dekker",
  "Brouwer",
  "de Wit",
  "Dijkstra",
  "Smits",
  "de Graaf",
  "van der Meer",
  "van der Linden",
  "Kok",
  "Jacobs",
  "de Haan",
  "Vermeulen",
  "van den Heuvel",
  "van der Veen",
  "van den Broek",
  "de Bruijn",
  "de Bruin",
  "van der Heijden",
  "Schouten",
  "van Beek",
  "Willems",
  "van Vliet",
  "van de Ven",
  "Hoekstra",
  "Maas",
  "Verhoeven",
  "Koster",
  "van Dam",
  "van der Wal",
  "Prins",
  "Blom",
  "Huisman",
  "Peeters",
  "Kuipers",
  "van Veen",
  "van Dongen",
  "Veenstra",
  "Kramer",
  "van den Bosch",
  "van der Meulen",
  "Mol",
  "Zwart",
  "van der Laan",
  "Martens",
  "van de Pol",
  "Postma",
  "Tromp",
  "Borst",
  "Boon",
  "van Doorn",
  "Jonker",
  "van der Velden",
  "Willemsen",
  "van Wijk",
  "Groen",
  "Gerritsen",
  "Bosch",
  "van Loon",
  "van der Ploeg",
  "de Ruiter",
  "Molenaar",
  "Boer",
  "Klein",
  "de Koning",
  "van de Kamp",
  "van der Horst",
  "Verbeek",
  "Vink",
  "Goossens",
  "Scholten",
  "Hartman",
  "van Dalen",
  "van Elst",
  "Brink",
  "Boekel",
  "van de Berg",
  "Berends",
  "van der Hoek",
  "Kuiper",
  "Kooijman",
  "de Lange",
  "van der Sluis",
  "van Gelder",
  "Martens",
  "van Asselt",
  "Timmermans",
  "van Vliet",
  "van Rijn",
  "van Schaik",
  "Bosman",
  "Wolters",
  "van Hout",
  "Hermans",
  "van Rooij",
  "de Vos",
  "van Donselaar",
  "Evers",
  "van den Brink",
  "Verkerk",
  "Groeneveld",
  "van Duijn",
  "Schuurman",
  "Hoogendoorn",
  "van Zanten",
  "Koopman",
  "Cornelissen",
  "van Driel",
  "Teunissen",
  "Versteeg",
  "van Deursen",
  "Schipper",
  "van Kempen",
  "Bouwman",
  "van der Valk",
  "Nijhuis",
  "van der Werf",
  "van den Akker",
  "Verhoef",
  "Wessels",
  "van der Poel",
  "Driessen",
  "van Oosten",
  "Lambrechts",
  "van der Vlist",
  "Hoogeveen",
  "van Gils",
  "Rietveld",
  "Barendrecht",
  "van der Spek",
  "Stam",
  "van der Linde",
  "Boersma",
  "van Dijk",
  "Schepers",
  "van der Kolk",
  "Roelofs",
  "van der Velden",
  "van den Burg",
  "Westra",
  "van der Steen",
  "Pronk",
  "van der Veer",
  "Rozendaal",
  "van den Bos",
  "Konings",
  "van der Wiel",
  "Noordam",
  "van der Laan",
  "Schut",
  "van der Vlugt",
  "Witteveen",
  "van der Zwan",
  "Boogaard",
  "van der Waal",
  "Stolk",
  "van der Windt",
  "Rutten",
  "van der Zanden",
  "Spaans",
  "van der Zwaan",
  "Roos",
  "van der Zijl",
  "Schoenmaker",
  "van Diepen",
  "Romeijn",
  "van Doesburg",
  "Schippers",
  "van Eck",
  "Rijken",
  "van Egmond",
  "Schrama",
  "van Eijk",
  "Ruijter",
  "van Engelen",
  "Sanders",
  "van Es",
  "Schenk",
  "van Essen",
  "van Gaal",
  "van Geenen",
  "van Gent",
  "van Gestel",
  "van Gool",
  "van Grinsven",
  "van Gurp",
  "van Haaften",
  "van Haren",
  "van Hattem",
  "van Hees"
];

// src/implementations/IdentityGeneratorNl.ts
var IdentityGeneratorNl = class extends IdentityGenerator {
  /**
   * Get the male first names.
   */
  getFirstNamesMaleJson() {
    return firstnames_male_default2;
  }
  /**
   * Get the female first names.
   */
  getFirstNamesFemaleJson() {
    return firstnames_female_default2;
  }
  /**
   * Get the last names.
   */
  getLastNamesJson() {
    return lastnames_default2;
  }
};

// src/dictionaries/de/lastnames.ts
var lastnames_default3 = [
  "M\xFCller",
  "Schmidt",
  "Schneider",
  "Fischer",
  "Weber",
  "Meyer",
  "Wagner",
  "Schulz",
  "Becker",
  "Hoffmann",
  "Sch\xE4fer",
  "Koch",
  "Richter",
  "Bauer",
  "Klein",
  "Wolf",
  "Schr\xF6der",
  "Neumann",
  "Schwarz",
  "Zimmermann",
  "Braun",
  "Hofmann",
  "Kr\xFCger",
  "Hartmann",
  "Lange",
  "Schmitt",
  "Werner",
  "Schmitz",
  "Krause",
  "Meier",
  "Lehmann",
  "Schmid",
  "Schulze",
  "Maier",
  "K\xF6hler",
  "Herrmann",
  "Walter",
  "K\xF6nig",
  "Mayer",
  "Huber",
  "Kaiser",
  "Fuchs",
  "Peters",
  "Lang",
  "Scholz",
  "M\xF6ller",
  "Wei\xDF",
  "Jung",
  "Hahn",
  "Schubert",
  "Vogel",
  "Friedrich",
  "G\xFCnther",
  "Keller",
  "Winkler",
  "Frank",
  "Berger",
  "Roth",
  "Beck",
  "Lorenz",
  "Baumann",
  "Franke",
  "Albrecht",
  "Schuster",
  "Simon",
  "Ludwig",
  "B\xF6hm",
  "Winter",
  "Kraus",
  "Martin",
  "Schumacher",
  "Kr\xE4mer",
  "Vogt",
  "Otto",
  "J\xE4ger",
  "Stein",
  "Gro\xDF",
  "Sommer",
  "Seidel",
  "Heinrich",
  "Haas",
  "Brandt",
  "Schreiber",
  "Graf",
  "Dietrich",
  "Schulte",
  "K\xFChn",
  "Ziegler",
  "Kuhn",
  "Pohl",
  "Engel",
  "Horn",
  "Bergmann",
  "Voigt",
  "Busch",
  "Thomas",
  "Sauer",
  "Arnold",
  "Pfeiffer",
  "Wolff",
  "Beyer",
  "Seifert",
  "Ernst",
  "Lindner",
  "H\xFCbner",
  "Kramer",
  "Jansen",
  "Franz",
  "Peter",
  "Hansen",
  "Wenzel",
  "G\xF6tz",
  "Paul",
  "Riedel",
  "Barth",
  "Kern",
  "Hermann",
  "Nagel",
  "Wilhelm",
  "Ott",
  "Bock",
  "Langer",
  "Grimm",
  "Ritter",
  "Haase",
  "Lenz",
  "F\xF6rster",
  "Mohr",
  "Kruse",
  "Schumann",
  "Jahn",
  "Thiel",
  "Kaufmann",
  "Zimmer",
  "Hoppe",
  "Petersen",
  "Fiedler",
  "Berg",
  "Arndt",
  "Marx",
  "Lutz",
  "Fritz",
  "Kraft",
  "Michel",
  "Walther",
  "B\xF6ttcher",
  "Sch\xFCtz",
  "Eckert",
  "Sander",
  "Thiele",
  "Reuter",
  "Reinhardt",
  "Schindler",
  "Ebert",
  "Kunz",
  "Schilling",
  "Schramm",
  "Vo\xDF",
  "Nowak",
  "Hein",
  "Hesse",
  "Frey",
  "Rudolph",
  "Fr\xF6hlich",
  "Beckmann",
  "Kunze",
  "Herzog",
  "Bayer",
  "Behrens",
  "Stephan",
  "B\xFCttner",
  "Gruber",
  "Adam",
  "G\xE4rtner",
  "Witt",
  "Maurer",
  "Bender",
  "Bachmann",
  "Schultz",
  "Seitz",
  "Geiger",
  "Stahl",
  "Steiner",
  "Scherer",
  "Kirchner",
  "Dietz",
  "Ullrich",
  "Kurz",
  "Breuer",
  "Gerlach",
  "Ulrich",
  "Brinkmann",
  "Fink",
  "Heinz",
  "L\xF6ffler",
  "Reichert",
  "Naumann",
  "B\xF6hme",
  "Schr\xF6ter",
  "Blum",
  "G\xF6bel",
  "Moser",
  "Schl\xFCter",
  "Brunner",
  "K\xF6rner",
  "Schenk",
  "Wirth",
  "Wegner",
  "Brand",
  "Wendt",
  "Stark",
  "Schwab",
  "Krebs",
  "Heller",
  "Wolter",
  "Reimann",
  "Rieger",
  "Unger",
  "Binder",
  "Bruns",
  "D\xF6ring",
  "Menzel",
  "Buchholz",
  "Ackermann",
  "Rose",
  "Mei\xDFner",
  "Janssen",
  "Bartsch",
  "May",
  "Hirsch",
  "Jakob",
  "Schiller",
  "Kopp",
  "John",
  "Hinz",
  "Bach",
  "Pfeifer",
  "Bischoff",
  "Engelhardt",
  "Wilke",
  "Sturm",
  "Hildebrandt",
  "Siebert",
  "Urban",
  "Link",
  "Rohde",
  "Kohl",
  "Linke",
  "Wittmann",
  "Fricke",
  "K\xF6ster",
  "Gebhardt",
  "Weiss",
  "Vetter",
  "Freitag",
  "Nickel",
  "Hennig",
  "Rau",
  "M\xFCnch",
  "Witte",
  "Noack",
  "Renner",
  "Westphal",
  "Reich",
  "Will",
  "Baier",
  "Kolb",
  "Br\xFCckner",
  "Marquardt",
  "Kiefer",
  "Keil",
  "Henning",
  "Heinze",
  "Funk",
  "Lemke",
  "Ahrens",
  "Esser",
  "Pieper",
  "Baum",
  "Conrad",
  "Schlegel",
  "Fuhrmann",
  "Decker",
  "Jacob",
  "Held",
  "R\xF6der",
  "Berndt",
  "Hanke",
  "Kirsch",
  "Neubauer",
  "Hammer",
  "Stoll",
  "Erdmann",
  "Mann",
  "Philipp",
  "Sch\xF6n",
  "Wiese",
  "Kremer",
  "Bartels",
  "Klose",
  "Mertens",
  "Schreiner",
  "Dittrich",
  "Krieger",
  "Kr\xF6ger",
  "Krug",
  "Harms",
  "Henke",
  "Gro\xDFmann",
  "Martens",
  "He\xDF",
  "Schrader",
  "Strau\xDF",
  "Adler",
  "Herbst",
  "K\xFChne",
  "Heine",
  "Konrad",
  "Kluge",
  "Henkel",
  "Wiedemann",
  "Albert",
  "Popp",
  "Wimmer",
  "Karl",
  "Wahl",
  "Stadler",
  "Hamann",
  "Kuhlmann",
  "Steffen",
  "Lindemann",
  "Fritsch",
  "Bernhardt",
  "Burkhardt",
  "Preu\xDF",
  "Metzger",
  "Bader",
  "Nolte",
  "Hauser",
  "Blank",
  "Beier",
  "Klaus",
  "Probst",
  "Hess",
  "Zander",
  "Miller",
  "Niemann",
  "Funke",
  "Haupt",
  "Burger",
  "Bode",
  "Holz",
  "Jost",
  "Rauch",
  "Rothe",
  "Herold",
  "Jordan",
  "Anders",
  "Fleischer",
  "Wiegand",
  "Hartung",
  "Jan\xDFen",
  "Lohmann",
  "Krau\xDF",
  "Vollmer",
  "Baur",
  "Heinemann",
  "Wild",
  "Brenner",
  "Reichel",
  "Wetzel",
  "Christ",
  "Rausch",
  "Hummel",
  "Reiter",
  "Mayr",
  "Knoll",
  "Kroll",
  "Wegener",
  "Beer",
  "Schade",
  "Neubert",
  "Merz",
  "Sch\xFCler",
  "Strobel",
  "Diehl",
  "Behrendt",
  "Glaser",
  "Feldmann",
  "Hagen",
  "Jacobs",
  "Rupp",
  "Gei\xDFler",
  "Straub",
  "Hohmann",
  "R\xF6mer",
  "Stock",
  "Haag",
  "Meister",
  "Freund",
  "D\xF6rr",
  "Kessler",
  "Betz",
  "Seiler",
  "Altmann",
  "Weise",
  "Metz",
  "Eder",
  "Busse",
  "Mai",
  "Wunderlich",
  "Sch\xFCtte",
  "Hentschel",
  "Voss",
  "Weis",
  "Heck",
  "Born",
  "Falk",
  "Raab",
  "Lauer",
  "V\xF6lker",
  "Bittner",
  "Merkel",
  "Sonntag",
  "Moritz",
  "Ehlers",
  "Bertram",
  "Hartwig",
  "Rapp",
  "Gerber",
  "Zeller",
  "Scharf",
  "Pietsch",
  "Kellner",
  "B\xE4r",
  "Eichhorn",
  "Giese",
  "Wulf",
  "Block",
  "Opitz",
  "Gottschalk",
  "J\xFCrgens",
  "Greiner",
  "Wieland",
  "Benz",
  "Ke\xDFler",
  "Steffens",
  "Heil",
  "Seeger",
  "Stumpf",
  "Gross",
  "B\xFChler",
  "Eberhardt",
  "Hiller",
  "Buck",
  "Weigel",
  "Schweizer",
  "Albers",
  "Heuer",
  "Pape",
  "Hempel",
  "Schott",
  "Sch\xFCtze",
  "Scheffler",
  "Engelmann",
  "Wiesner",
  "Runge",
  "Geyer",
  "Neuhaus",
  "Forster",
  "Oswald",
  "Radtke",
  "Heim",
  "Geisler",
  "Appel",
  "Weidner",
  "Seidl",
  "Moll",
  "Dorn",
  "Klemm",
  "Barthel",
  "Gabriel",
  "Springer",
  "Timm",
  "Engels",
  "Kretschmer",
  "Reimer",
  "Steinbach",
  "Hensel",
  "Wichmann",
  "Eichler",
  "Hecht",
  "Winkelmann",
  "Heise",
  "Noll",
  "Fleischmann",
  "Neugebauer",
  "Hinrichs",
  "Schaller",
  "Lechner",
  "Brandl",
  "Mack",
  "Gebauer",
  "Siegel",
  "Zahn",
  "Singer",
  "Michels",
  "Schuler",
  "Scholl",
  "Uhlig",
  "Br\xFCggemann",
  "Specht",
  "B\xFCrger",
  "Eggert",
  "Baumgartner",
  "Weller",
  "Schnell",
  "B\xF6rner",
  "Brauer",
  "Kohler",
  "Pfaff",
  "Auer",
  "Drescher",
  "Otte",
  "Frenzel",
  "Petzold",
  "Rother",
  "Hagemann",
  "Sattler",
  "Wirtz",
  "Ruf",
  "Schirmer",
  "Sauter",
  "Sch\xFCrmann",
  "Junker",
  "Walz",
  "Dreyer",
  "Sievers",
  "Haller",
  "Prinz",
  "Stolz",
  "Hausmann",
  "Dick",
  "Lux",
  "Schnabel",
  "Elsner",
  "K\xFChl",
  "Gerhardt",
  "Klotz",
  "Rabe",
  "Schick",
  "Faber",
  "Riedl",
  "Kranz",
  "Fries",
  "Reichelt",
  "R\xF6sch",
  "Langner",
  "Maa\xDF",
  "Wittig",
  "Geier",
  "Finke",
  "Kasper",
  "Maas",
  "Bremer",
  "Rath",
  "Knapp",
  "Dittmann",
  "Kahl",
  "Volk",
  "Faust",
  "Harder",
  "Biermann",
  "P\xFCtz",
  "Kempf",
  "Mielke",
  "Michaelis",
  "Yilmaz",
  "Abel",
  "Thieme",
  "Sch\xFCtt",
  "Hauck",
  "Cordes",
  "Eberle",
  "Schaefer",
  "Wehner",
  "Haug",
  "Fritzsche",
  "Kilian",
  "Eggers",
  "Gro\xDFe",
  "Matthes",
  "Reinhold",
  "Paulus",
  "D\xFCrr",
  "Bohn",
  "Thoma",
  "Schober",
  "Koller",
  "Korn",
  "H\xF6hne",
  "Hering",
  "Gerdes",
  "Ullmann",
  "Jensen",
  "Endres",
  "Bernhard",
  "Leonhardt",
  "Eckhardt",
  "Schaaf",
  "H\xF6fer",
  "Junge",
  "Rademacher",
  "Pilz",
  "Hellwig",
  "Knorr",
  "Helbig",
  "Melzer",
  "Lippert",
  "Evers",
  "Bahr",
  "Klinger",
  "Heitmann",
  "Ehrhardt",
  "Heinrichs",
  "Horstmann",
  "Behr",
  "St\xF6hr",
  "Drews",
  "Rudolf",
  "Sieber",
  "Theis",
  "Groth",
  "Hecker",
  "Weiler",
  "Kemper",
  "Rost",
  "L\xFCck",
  "Claus",
  "Hildebrand",
  "Steinmetz",
  "G\xF6tze",
  "Trautmann",
  "Blume",
  "Kurth",
  "Augustin",
  "Nitsche",
  "Janke",
  "Jahnke",
  "Klug",
  "Damm",
  "Heimann",
  "Strauch",
  "Schlosser",
  "Uhl",
  "B\xF6hmer",
  "Ries",
  "Hellmann",
  "H\xF6hn",
  "Hertel",
  "Dreher",
  "Borchert",
  "Huth",
  "Sperling",
  "Just",
  "Stenzel",
  "Kunkel",
  "Lau",
  "Sprenger",
  "Sch\xF6nfeld",
  "Pohlmann",
  "Heilmann",
  "Wacker",
  "Lehner",
  "Teichmann",
  "Kaminski",
  "Vogl",
  "Gehrke",
  "Hartl",
  "Vogler",
  "Schroeder",
  "Thomsen",
  "Nitschke",
  "Engler",
  "Liedtke",
  "Wille",
  "Starke",
  "Friedrichs",
  "Kirchhoff",
  "Schwarze",
  "Balzer",
  "Reinhard",
  "Heinen",
  "Lotz",
  "K\xFCster",
  "Kretzschmar",
  "Sch\xF6ne",
  "Clemens",
  "Hornung",
  "Ulbrich",
  "Renz",
  "Hofer",
  "Ruppert",
  "Lohse",
  "Schuh",
  "Amann",
  "Westermann",
  "Stiller",
  "Burmeister",
  "Alt",
  "Hampel",
  "Brockmann",
  "Wessel",
  "Sp\xE4th",
  "Hoyer",
  "Mader",
  "Bartel",
  "R\xF6\xDFler",
  "Krieg",
  "Grote",
  "Schwarzer",
  "Schweitzer",
  "Scheer",
  "Bosch",
  "Zink",
  "Roos",
  "Wagener",
  "Oppermann",
  "Henze",
  "Lehnert",
  "Seemann",
  "Trapp",
  "Rei\xDF",
  "David",
  "Pfeffer",
  "Grau",
  "Horst",
  "Diekmann",
  "Korte",
  "Rehm",
  "Wilde",
  "Schleicher",
  "Lampe",
  "Grundmann",
  "Veit",
  "Daniel",
  "Eisele",
  "Hafner",
  "Steinert",
  "Sachs",
  "Pfister",
  "K\xFChnel",
  "Sch\xFCller",
  "Klatt",
  "Bischof",
  "Wendel",
  "Tietz",
  "Frick",
  "Buschmann",
  "Steinke",
  "Menke",
  "Baumeister",
  "Kirschner",
  "Loos",
  "Ebner",
  "Kastner",
  "Wolters",
  "Orth",
  "Stange",
  "Becher",
  "Helm",
  "Knobloch",
  "W\xF6rner",
  "Heyer",
  "Nguyen",
  "Baumg\xE4rtner",
  "Grund",
  "Br\xFCning",
  "Ostermann",
  "Cremer",
  "Schauer",
  "Jacobi",
  "Ewald",
  "F\xFCrst",
  "Widmann",
  "Otten",
  "B\xFCchner",
  "Petri",
  "Fritsche",
  "Kock",
  "Ehlert",
  "Kleine",
  "Eckstein",
  "Hacker",
  "Brandes",
  "Buchner",
  "Hagedorn",
  "Keck",
  "H\xE4usler",
  "Muth",
  "Apel",
  "Heuser",
  "Bastian",
  "Kersten",
  "Stamm",
  "Niemeyer",
  "Berthold",
  "Gehrmann",
  "Weinert",
  "Schatz",
  "Hager",
  "Volkmann",
  "Michael",
  "Wieczorek",
  "Wilms",
  "Burghardt",
  "Schultze",
  "Merten",
  "Schwartz",
  "Kling",
  "Rode",
  "Neu",
  "Mende",
  "Thies",
  "B\xF6ttger",
  "Schell",
  "Spindler",
  "Pabst",
  "Gr\xFCn",
  "Weiland",
  "M\xFChlbauer",
  "Hanisch",
  "Doll",
  "Janzen",
  "Adams",
  "Hermes",
  "Haack",
  "Cramer",
  "Spies",
  "Stern",
  "Kugler",
  "Budde",
  "Jakobs",
  "Scheller",
  "R\xF6sler",
  "Reiser",
  "Jonas",
  "Herr",
  "Ebeling",
  "Wulff",
  "Pauli",
  "L\xF6hr",
  "Lukas",
  "Rahn",
  "Sachse",
  "K\xF6hn",
  "Backhaus",
  "Mahler",
  "Hille",
  "Kowalski",
  "Heidrich",
  "Br\xFCck",
  "Gottwald",
  "Heidenreich",
  "Baumgarten",
  "Hamm",
  "K\xF6rber",
  "K\xFCbler",
  "Frisch",
  "Hardt",
  "Enders",
  "Br\xE4uer",
  "Seidler",
  "K\xFCpper",
  "Lauterbach",
  "Zeidler",
  "Eckardt",
  "Kreuzer",
  "Schiffer",
  "Schaper",
  "Gehring",
  "Hannemann",
  "Ortmann",
  "Petry",
  "Thiemann",
  "Tiedemann",
  "Gr\xFCnewald",
  "Johannsen",
  "Scheel",
  "Volz",
  "Kunert",
  "Dieckmann",
  "Bormann",
  "Obermeier",
  "Knauer",
  "Schaub",
  "Eilers",
  "Berner",
  "Pahl",
  "Reinecke",
  "Herz",
  "Henn",
  "Brehm",
  "Hoff",
  "Resch",
  "Ochs",
  "Krohn",
  "Lerch",
  "Raabe",
  "Ehrlich",
  "Hack",
  "Friedl",
  "Reis",
  "Rogge",
  "Meurer",
  "Thelen",
  "Drechsler",
  "H\xF6lscher",
  "Morgenstern",
  "Sommerfeld",
  "Ebel",
  "Kellermann",
  "Rupprecht",
  "Post",
  "Hillebrand",
  "Hill",
  "Paulsen",
  "Grabowski",
  "Bolz",
  "Lorenzen",
  "Welsch",
  "Seibel",
  "Kleinert",
  "Schr\xF6er",
  "Jaeger",
  "W\xE4chter",
  "Boldt",
  "Palm",
  "Kratz",
  "Reimers",
  "Pusch",
  "Exner",
  "Dietze",
  "W\xFCst",
  "Andres",
  "Heide",
  "Kaya",
  "Reichardt",
  "Kummer",
  "Metzner",
  "Grube",
  "Ewert",
  "Grunwald",
  "Habermann",
  "Zorn",
  "Fichtner",
  "Emmerich",
  "Mangold",
  "Reif",
  "Ahlers",
  "K\xE4stner",
  "K\xFCppers",
  "Petermann",
  "Stratmann",
  "Sailer",
  "Schuhmacher",
  "Hoch",
  "Struck",
  "Buchmann",
  "Rauscher",
  "L\xFCdtke",
  "Wendler",
  "Dreier",
  "Z\xF6ller",
  "Bucher",
  "Siegert",
  "Finger",
  "Hopf",
  "Rieck",
  "Friese",
  "Hopp",
  "Sahin",
  "Henrich",
  "Spengler"
];

// src/dictionaries/de/firstnames_male_1950_1959.ts
var firstnames_male_1950_1959_default = [
  "Michael",
  "Peter",
  "Hans",
  "Klaus",
  "Wolfgang",
  "Thomas",
  "J\xFCrgen",
  "Andreas",
  "Bernd",
  "Manfred",
  "Rainer",
  "Uwe",
  "Dieter",
  "Joachim",
  "Karl",
  "Holger",
  "Werner",
  "Ralf",
  "Frank",
  "Norbert",
  "Ulrich",
  "Rolf",
  "J\xF6rg",
  "Gerhard",
  "G\xFCnther",
  "Helmut",
  "Harald",
  "Jens",
  "Horst",
  "Heinz",
  "Reinhardt",
  "Martin",
  "Detlef",
  "Stefan",
  "Matthias",
  "Volker",
  "Christian",
  "Gerd",
  "R\xFCdiger",
  "Alexander",
  "Bernhard",
  "Hartmut",
  "Walter",
  "Herbert",
  "Georg",
  "Ronald",
  "Axel",
  "Roland",
  "Dirk",
  "Josef",
  "Lothar",
  "Wilfried",
  "Jan",
  "Karsten",
  "Udo",
  "Ingo",
  "Hermann",
  "Kurt",
  "Olaf",
  "Franz",
  "Siegfried",
  "Dietmar",
  "Mohammed",
  "Heinrich",
  "Alfred",
  "Christoph",
  "Viktor",
  "Lutz",
  "Johannes",
  "Torsten",
  "Kai",
  "Rudolf",
  "Richard",
  "Waldemar",
  "Robert",
  "J\xF6rn",
  "Johann",
  "Ernst",
  "Reinhold",
  "Eckhard",
  "Friedrich",
  "Burghard",
  "Wilhelm",
  "Heiko",
  "Jochen",
  "Harry",
  "Hubert",
  "Paul",
  "Erich",
  "Fred",
  "Achim",
  "Ali",
  "Wolf",
  "Erwin",
  "Mario",
  "Andre",
  "Eberhard",
  "Winfried",
  "Heino",
  "Sven",
  "Willi",
  "Ulf",
  "Bodo",
  "Henry",
  "Vladimir",
  "Dietrich",
  "John",
  "Armin",
  "Edgar",
  "Friedhelm",
  "Gunnar",
  "Arno",
  "Fritz",
  "Gerald",
  "Henning",
  "Abdul",
  "Karlheinz",
  "Andrzej",
  "Markus",
  "Otto",
  "Roman",
  "Knut",
  "Wolfram",
  "Nobert",
  "Gunther",
  "Konrad",
  "Heiner",
  "Mehmet",
  "Nils",
  "Bruno"
];

// src/dictionaries/de/firstnames_male_1960_1969.ts
var firstnames_male_1960_1969_default = [
  "Thomas",
  "Michael",
  "Andreas",
  "Stefan",
  "Frank",
  "Torsten",
  "Peter",
  "J\xF6rg",
  "Ralf",
  "Matthias",
  "Christian",
  "Dirk",
  "Jens",
  "Martin",
  "Klaus",
  "J\xFCrgen",
  "Karsten",
  "Uwe",
  "Bernd",
  "Markus",
  "Oliver",
  "Sven",
  "Wolfgang",
  "Holger",
  "Olaf",
  "Hans",
  "Rainer",
  "Kai",
  "Jan",
  "Volker",
  "Joachim",
  "Christoph",
  "Alexander",
  "Axel",
  "Heiko",
  "Norbert",
  "Manfred",
  "Andre",
  "Dieter",
  "Robert",
  "Ulrich",
  "Detlef",
  "Harald",
  "Ingo",
  "Marc",
  "Roland",
  "Lars",
  "Rolf",
  "Marco",
  "Jochen",
  "Guido",
  "Mike",
  "J\xF6rn",
  "Georg",
  "Gerhard",
  "R\xFCdiger",
  "Mario",
  "Lutz",
  "Bernhard",
  "Nils",
  "Udo",
  "Dietmar",
  "Gerd",
  "Karl",
  "Horst",
  "G\xFCnther",
  "Steffen",
  "Johannes",
  "Werner",
  "Ronald",
  "Arne",
  "Daniel",
  "Helmut",
  "Achim",
  "Mohammed",
  "Ren\xE9",
  "Ulf",
  "Hartmut",
  "Bj\xF6rn",
  "Erik",
  "Heinz",
  "Patrick",
  "Viktor",
  "Walter",
  "Ali",
  "Gerald",
  "Reinhardt",
  "Henning",
  "Tobias",
  "Mehmet",
  "Armin",
  "Sebastian",
  "Helge",
  "Gunnar",
  "Richard",
  "Waldemar",
  "Josef",
  "Knut",
  "Boris",
  "Hermann",
  "Paul",
  "Burghard",
  "Florian",
  "Lothar",
  "S\xF6nke",
  "Tim",
  "Philipp",
  "Franz",
  "Clemens",
  "Wilfried",
  "Siegfried",
  "Johann",
  "Ahmet",
  "Eckhard",
  "Fred",
  "Heinrich",
  "Roman",
  "John",
  "Arno",
  "Mustafa",
  "Hasan",
  "Gregor",
  "Alfred",
  "Arnd",
  "Rudolf",
  "Sergej",
  "David",
  "Manuel",
  "Marcel",
  "Friedrich",
  "Jos\xE9",
  "Marek",
  "Mirko",
  "Sascha",
  "Thilo",
  "Bodo",
  "Darius",
  "Hendrik",
  "Herbert",
  "Nikolai",
  "Wolf",
  "Nikola",
  "Roger",
  "Edgar",
  "Ernst",
  "Henry",
  "Wolfram",
  "Christopher",
  "Vladimir",
  "Gunther",
  "H\xFCseyin",
  "Harry",
  "Hauke",
  "Wilhelm",
  "Arthur",
  "Winfried",
  "Henrik",
  "Antonio",
  "Felix",
  "Anton",
  "Bruno",
  "Igor",
  "G\xF6tz",
  "Tom",
  "Heino",
  "Abdul",
  "Miroslaw",
  "S\xF6ren",
  "Bert",
  "Elmar",
  "Hubert",
  "Kurt",
  "Ole",
  "Tillmann",
  "Ahmad",
  "Andrej",
  "Dennis",
  "Adam",
  "Ibrahim",
  "Malte",
  "Raphael",
  "Reinhold",
  "Eduard",
  "Erwin",
  "Marius",
  "Nikolaus",
  "Carlos",
  "Ismail",
  "Nico",
  "Gernot",
  "Jacek",
  "Nicolas",
  "Peer",
  "Albert",
  "Heiner",
  "Timo",
  "Andrzej",
  "Jean",
  "Berthold",
  "Hanno"
];

// src/dictionaries/de/firstnames_male_1970_1979.ts
var firstnames_male_1970_1979_default = [
  "Christian",
  "Michael",
  "Stefan",
  "Andreas",
  "Markus",
  "Thomas",
  "Matthias",
  "Sven",
  "Jan",
  "Alexander",
  "Oliver",
  "Martin",
  "Torsten",
  "Frank",
  "Marco",
  "Marc",
  "Jens",
  "Daniel",
  "Karsten",
  "Andre",
  "Sebastian",
  "Lars",
  "Dirk",
  "Tobias",
  "J\xF6rg",
  "Sascha",
  "Kai",
  "Florian",
  "Christoph",
  "Bj\xF6rn",
  "Peter",
  "Dennis",
  "Mike",
  "Ralf",
  "Patrick",
  "Robert",
  "Holger",
  "Ren\xE9",
  "Nils",
  "Heiko",
  "Mario",
  "Philipp",
  "Olaf",
  "Steffen",
  "Tim",
  "Timo",
  "Ingo",
  "J\xFCrgen",
  "Volker",
  "Marcel",
  "Benjamin",
  "Bernd",
  "Axel",
  "Arne",
  "Klaus",
  "David",
  "J\xF6rn",
  "Felix",
  "Boris",
  "Henning",
  "Wolfgang",
  "Uwe",
  "Mirko",
  "Torben",
  "Johannes",
  "Nico",
  "Manuel",
  "Jochen",
  "Hans",
  "Ali",
  "Joachim",
  "Malte",
  "Mohammed",
  "Roland",
  "Simon",
  "Rainer",
  "Fabian",
  "Gunnar",
  "Ulrich",
  "Ronny",
  "Mehmet",
  "Erik",
  "Guido",
  "Sergej",
  "Hendrik",
  "Viktor",
  "Dominik",
  "Roman",
  "Georg",
  "Bastian",
  "Murat",
  "Helge",
  "S\xF6ren",
  "Christopher",
  "Karl",
  "Andrej",
  "Mustafa",
  "Ulf",
  "Lutz",
  "Ole",
  "Ahmet",
  "Moritz",
  "Enrico",
  "Nicolas",
  "S\xF6nke",
  "Paul",
  "Harald",
  "Norbert",
  "Henrik",
  "Raphael",
  "Nikolai",
  "Tom",
  "Danny",
  "Gerrit",
  "Hasan",
  "Gregor",
  "Arthur",
  "Bernhard",
  "Marius",
  "Konstantin",
  "Achim",
  "Norman",
  "John",
  "Thilo",
  "Waldemar",
  "Julian",
  "Clemens",
  "Hakan",
  "Till",
  "Ronald",
  "Eduard",
  "Erkan",
  "Hauke",
  "Manfred",
  "R\xFCdiger",
  "Adam",
  "Ahmad",
  "Klaas",
  "Ibrahim",
  "Vladimir",
  "Adrian",
  "Eugen",
  "Falk",
  "Maximilian",
  "Richard",
  "Andy",
  "Frederik",
  "Marek",
  "Tino",
  "Kevin",
  "Knut",
  "Pascal",
  "Arnd",
  "Detlef",
  "Gerald",
  "Max",
  "Darius",
  "Heinrich",
  "H\xFCseyin",
  "Igor",
  "Alexej",
  "Dieter",
  "Eike",
  "Tomasz",
  "Wilhelm",
  "Dietmar",
  "Franz",
  "Gerhard",
  "Johann",
  "Antonio",
  "Jos\xE9",
  "Rolf",
  "Abdul",
  "Peer",
  "Ismail",
  "Nikola",
  "B\xFClent",
  "Gerd",
  "Jakob",
  "Lukas",
  "Niklas",
  "Robin",
  "Gordon",
  "Friedrich",
  "Jonas",
  "Leif",
  "Michel",
  "Hermann",
  "Oleg",
  "Sandro",
  "Tillmann",
  "Burghard",
  "Henry",
  "Jean",
  "Steven",
  "Benedikt",
  "Nikolaus",
  "Ricardo",
  "Roberto",
  "Vitali",
  "Amir",
  "G\xFCnther",
  "Helmut",
  "Ivan",
  "Rico",
  "Falko",
  "Jacek",
  "Kim",
  "Krzysztof",
  "Piotr",
  "Said",
  "Silvio",
  "Udo",
  "Vitalij",
  "Werner",
  "Armin",
  "Ayhan",
  "Bodo",
  "Carlos",
  "Cengiz",
  "Josef",
  "Pierre",
  "\xD6mer",
  "Arno",
  "Atilla",
  "Birger",
  "Dimitri",
  "Georgios",
  "G\xF6tz",
  "Hagen",
  "Hannes",
  "Hartmut",
  "Juan",
  "Kolja",
  "Marcin",
  "Toni",
  "Louis",
  "Metin",
  "Paulo",
  "Pawel",
  "Yusuf",
  "Albert",
  "Alex",
  "Chris",
  "Gunther",
  "Lasse",
  "Orhan",
  "Ramazan",
  "Rudolf",
  "Walter"
];

// src/dictionaries/de/firstnames_male_1980_1989.ts
var firstnames_male_1980_1989_default = [
  "Christian",
  "Sebastian",
  "Jan",
  "Daniel",
  "Stefan",
  "Alexander",
  "Michael",
  "Dennis",
  "Martin",
  "Florian",
  "Tobias",
  "Matthias",
  "Philipp",
  "Patrick",
  "Thomas",
  "Benjamin",
  "Andreas",
  "Markus",
  "Christoph",
  "Marcel",
  "Sven",
  "Sascha",
  "Tim",
  "David",
  "Felix",
  "Johannes",
  "Robert",
  "Marco",
  "Andre",
  "Marc",
  "Oliver",
  "Christopher",
  "Nils",
  "Fabian",
  "Simon",
  "Bj\xF6rn",
  "Timo",
  "Ren\xE9",
  "Dominik",
  "Julian",
  "Jens",
  "Lars",
  "Peter",
  "Steffen",
  "Manuel",
  "Lukas",
  "Moritz",
  "Maximilian",
  "Jonas",
  "Mike",
  "Kai",
  "Frank",
  "Paul",
  "Kevin",
  "Torben",
  "Nico",
  "Karsten",
  "Torsten",
  "Mario",
  "Malte",
  "Bastian",
  "Hendrik",
  "Max",
  "Dirk",
  "Pascal",
  "Erik",
  "S\xF6ren",
  "Arne",
  "Jakob",
  "Nicolas",
  "Konstantin",
  "Niklas",
  "Marius",
  "Frederik",
  "Roman",
  "Henning",
  "J\xF6rg",
  "Mirko",
  "Mohammed",
  "Viktor",
  "Ali",
  "Ralf",
  "Raphael",
  "Adrian",
  "Danny",
  "Steven",
  "Ole",
  "Hannes",
  "Lennard",
  "Benedikt",
  "Georg",
  "Marvin",
  "Eugen",
  "Robin",
  "Jochen",
  "Tom",
  "Arthur",
  "Heiko",
  "Nikolai",
  "Jannik",
  "Till",
  "Hans",
  "Richard",
  "Henrik",
  "Pierre",
  "Ronny",
  "Sergej",
  "Holger",
  "Jannis",
  "John",
  "Boris",
  "J\xF6rn",
  "Michel",
  "Johann",
  "Gregor",
  "Klaus",
  "Norman",
  "Clemens",
  "Hauke",
  "Jonathan",
  "Vincent",
  "Enrico",
  "Kim",
  "Axel",
  "Andrej",
  "Toni",
  "Karl",
  "Waldemar",
  "Bernd",
  "Mehmet",
  "Anton",
  "Wolfgang",
  "Ahmad",
  "Mustafa",
  "Andy",
  "Ahmet",
  "Lasse",
  "Tino",
  "Eike",
  "Gerrit",
  "Konrad",
  "Joachim",
  "Steve",
  "Julius",
  "Eduard",
  "Murat",
  "Dimitri",
  "Friedrich",
  "Gunnar",
  "J\xFCrgen",
  "Adam",
  "Ibrahim",
  "Maurice",
  "Klaas",
  "S\xF6nke",
  "Bernhard",
  "Igor",
  "Tillmann",
  "Alexej",
  "Chris",
  "Vladimir",
  "Serkan",
  "Thilo",
  "Helge",
  "Olaf",
  "Roland",
  "Gabriel",
  "Nick",
  "Falk",
  "Nikola",
  "Rico",
  "Kolja",
  "Leif",
  "Pawel",
  "Amir",
  "Ingo",
  "Jascha",
  "Alex",
  "Fatih",
  "G\xF6khan",
  "Hakan",
  "Hasan",
  "Kamil",
  "Lutz",
  "Marcin",
  "Uwe",
  "Achim",
  "Finn",
  "Samuel",
  "Valentin",
  "Vitali",
  "Damian",
  "Dustin",
  "Franz",
  "Leon",
  "Darius",
  "Erkan",
  "Henry",
  "Maxim",
  "Peer"
];

// src/dictionaries/de/firstnames_male_1990_1999.ts
var firstnames_male_1990_1999_default = [
  "Jan",
  "Lukas",
  "Philipp",
  "Tim",
  "Alexander",
  "Daniel",
  "Tobias",
  "Dennis",
  "Marcel",
  "Felix",
  "Kevin",
  "Florian",
  "Maximilian",
  "Niklas",
  "Jonas",
  "Sebastian",
  "Patrick",
  "Fabian",
  "Christian",
  "Jannik",
  "Julian",
  "David",
  "Marvin",
  "Timo",
  "Marc",
  "Nico",
  "Simon",
  "Finn",
  "Dominik",
  "Nils",
  "Leon",
  "Pascal",
  "Lennard",
  "Max",
  "Tom",
  "Christopher",
  "Benjamin",
  "Moritz",
  "Paul",
  "Lars",
  "Marco",
  "Sven",
  "Christoph",
  "Robin",
  "Johannes",
  "Malte",
  "Michael",
  "Torben",
  "Jakob",
  "Matthias",
  "Martin",
  "Stefan",
  "Mike",
  "Andre",
  "Jannis",
  "Hendrik",
  "Luca",
  "Bj\xF6rn",
  "Nicolas",
  "Markus",
  "Ren\xE9",
  "Vincent",
  "Jonathan",
  "Steven",
  "Frederik",
  "Sascha",
  "Thomas",
  "Erik",
  "Robert",
  "Oliver",
  "Andreas",
  "Nick",
  "Marius",
  "Kai",
  "Ole",
  "Manuel",
  "Joshua",
  "Justin",
  "Steffen",
  "Adrian",
  "Konstantin",
  "Benedikt",
  "Lasse",
  "Louis",
  "Maurice",
  "Julius",
  "Mirko",
  "Anton",
  "Till",
  "John",
  "Henrik",
  "Henry",
  "Bastian",
  "S\xF6ren",
  "Leonard",
  "Raphael",
  "Johann",
  "Arne",
  "Hannes",
  "Michel",
  "Karl",
  "Mario",
  "Ben",
  "Mohammed",
  "Viktor",
  "Linus",
  "Nikolai",
  "Dustin",
  "Aaron",
  "Valentin",
  "Peter",
  "Toni",
  "Henning",
  "Marlon",
  "Clemens",
  "Danny",
  "Justus",
  "Jasper",
  "Julien",
  "Chris",
  "Jens",
  "Joel",
  "Hauke",
  "Kim",
  "Richard",
  "Gerrit",
  "Cedric",
  "Pierre",
  "Karsten",
  "Thore",
  "Vivian",
  "Mats",
  "Ricardo",
  "Arthur",
  "Bennet",
  "Fabio",
  "Jannek",
  "Kilian",
  "Leo",
  "Melvin",
  "Noah",
  "Samuel",
  "Timon",
  "Eike",
  "Ali",
  "Leif",
  "Peer",
  "Jean",
  "Hans",
  "Jeremy",
  "Merlin",
  "Jannes",
  "Calvin",
  "Jona",
  "Elias",
  "Lorenz",
  "Marten",
  "Can",
  "Dario",
  "Georg",
  "Ahmet",
  "Enrico",
  "Oskar",
  "Tristan",
  "Jascha",
  "Roman",
  "Colin",
  "Gabriel",
  "Jason",
  "Klaas",
  "Morten",
  "Nikola",
  "Phil",
  "S\xF6nke",
  "Alex",
  "Cem",
  "Konrad",
  "Mattis",
  "Rico",
  "Armin",
  "Brian",
  "Frank",
  "Gregor",
  "Ralf",
  "Thies",
  "Norman",
  "Ruben",
  "Ahmad",
  "Emre",
  "Levin",
  "Mehmet",
  "Torge",
  "Torsten",
  "Bjarne",
  "Kornelius",
  "Steve",
  "Jerome",
  "Marek",
  "Sandro",
  "Thilo",
  "Franz",
  "Kenneth",
  "Axel",
  "Burak",
  "J\xF6rn",
  "Kjell",
  "Milan",
  "Tjark",
  "Kolja",
  "Miguel",
  "Tillmann",
  "Emil",
  "Friedrich",
  "Lion",
  "Rasmus",
  "Tino",
  "Caspar",
  "Mert",
  "Amir",
  "Ibrahim",
  "Joe",
  "Leonhard",
  "Mustafa",
  "Onur",
  "Ferdinand",
  "Joscha",
  "Laurenz",
  "Maxim",
  "Sam",
  "Yasin",
  "Antonio",
  "Jeffrey",
  "Jendrik",
  "Nikolaus",
  "Philippe",
  "Sinan",
  "Damian",
  "Dirk",
  "Fritz",
  "Helge",
  "Juri",
  "Leander",
  "Matti",
  "Michele",
  "Nino",
  "Rouven",
  "Said",
  "Tarek",
  "Theo",
  "Timothy"
];

// src/dictionaries/de/firstnames_male_2000_2009.ts
var firstnames_male_2000_2009_default = [
  "Leon",
  "Lukas",
  "Luca",
  "Jonas",
  "Tim",
  "Finn",
  "Paul",
  "Felix",
  "Maximilian",
  "Louis",
  "Niklas",
  "Max",
  "Ben",
  "Julian",
  "Jan",
  "Philipp",
  "Elias",
  "Moritz",
  "Noah",
  "Jannik",
  "Jannis",
  "Tom",
  "Nico",
  "Simon",
  "David",
  "Alexander",
  "Fabian",
  "Erik",
  "Jakob",
  "Florian",
  "Nils",
  "Justin",
  "Lennard",
  "Nick",
  "Linus",
  "Daniel",
  "Tobias",
  "Jason",
  "Dominik",
  "Colin",
  "Marvin",
  "Mika",
  "Sebastian",
  "Kevin",
  "Johannes",
  "Julius",
  "Robin",
  "Jonathan",
  "Henry",
  "Hannes",
  "Anton",
  "Vincent",
  "Benjamin",
  "Marlon",
  "Timo",
  "Lenny",
  "Adrian",
  "Marc",
  "Joel",
  "Raphael",
  "Dennis",
  "Till",
  "Joshua",
  "Aaron",
  "Emil",
  "Pascal",
  "Ole",
  "Leonard",
  "Leo",
  "Lasse",
  "Marcel",
  "Samuel",
  "Konstantin",
  "Karl",
  "Oskar",
  "Lars",
  "Lennox",
  "Mattis",
  "Jona",
  "Kilian",
  "Christian",
  "Maurice",
  "Justus",
  "Jamie",
  "Oliver",
  "Malte",
  "Silas",
  "Michael",
  "Mohammed",
  "Jeremy",
  "John",
  "Phil",
  "Bastian",
  "Maxim",
  "Johann",
  "Liam",
  "Nicolas",
  "Mike",
  "Levin",
  "Benedikt",
  "Marco",
  "Noel",
  "Luke",
  "Bennet",
  "Cedric",
  "Gabriel",
  "Theo",
  "Matteo",
  "Tyler",
  "Valentin",
  "Fabio",
  "Marius",
  "Jayden",
  "Toni",
  "Richard",
  "Mats",
  "Hendrik",
  "Jannes",
  "Henrik",
  "Julien",
  "Manuel",
  "Arthur",
  "Patrick",
  "Matthias",
  "Frederik",
  "Connor",
  "Tristan",
  "Torben",
  "Markus",
  "Kai",
  "Martin",
  "Arda",
  "Andreas",
  "Damian",
  "Timon",
  "Franz",
  "Michel",
  "Levi",
  "Finley",
  "Robert",
  "Thomas",
  "Ian",
  "Arne",
  "Dustin",
  "Christopher",
  "Christoph",
  "Bruno",
  "Diego",
  "Matti",
  "Clemens",
  "Leander",
  "Magnus",
  "Milan",
  "Danny",
  "Laurin",
  "Lorenz",
  "Laurenz",
  "Sven",
  "Ali",
  "Leandro",
  "Steven",
  "Chris",
  "Dean",
  "Lenn",
  "Pepe",
  "Jasper",
  "Konrad",
  "Devin",
  "Can",
  "Domenik",
  "Friedrich",
  "Sean",
  "Kian",
  "Sam",
  "Kjell",
  "Ryan",
  "Andre",
  "Bjarne",
  "Ruben",
  "Stefan",
  "Nikita",
  "Ren\xE9",
  "Peter",
  "Hugo",
  "Melvin",
  "Jean",
  "Leopold",
  "Malik",
  "Willi",
  "Fritz",
  "Leonardo",
  "Quentin",
  "Ahmet",
  "Enrico",
  "Emilio",
  "Brian",
  "Ferdinand",
  "Antonio",
  "Marten",
  "Nevio",
  "Thore",
  "Joris",
  "Leonhard",
  "Roman",
  "Anthony",
  "Viktor",
  "Henning",
  "Sascha",
  "Alex",
  "Adam",
  "Elia",
  "Josef",
  "Theodor",
  "Jaron",
  "Leif",
  "Georg",
  "Piet",
  "Alessandro",
  "Kaan",
  "Lion",
  "Miguel",
  "Alessio",
  "Carlos",
  "Luan",
  "Ilyas",
  "Ricardo",
  "Yusuf",
  "Jannek",
  "Mert",
  "Peer",
  "Yasin",
  "Enes",
  "Marek",
  "Nino",
  "Arian",
  "Carlo",
  "Janne",
  "Gustav",
  "Hasan",
  "Mattes",
  "Mustafa",
  "William",
  "Jerome",
  "Milo",
  "Dario",
  "Mehmet",
  "Hans",
  "Thilo",
  "Neo",
  "S\xF6ren",
  "Mirko",
  "Sandro",
  "Tamino",
  "Emilian",
  "Bj\xF6rn",
  "Korbinian",
  "Pierre",
  "Emanuel",
  "Bela",
  "Benno",
  "Merlin",
  "Tino",
  "Keno",
  "Ludwig",
  "Emre",
  "Jordan",
  "Kerem",
  "Gianluca",
  "Ibrahim",
  "Jesse",
  "Mario",
  "Tjark",
  "Eddy",
  "Lian",
  "Fiete",
  "Etienne",
  "Klaas",
  "Marian",
  "Efe",
  "Jack",
  "Calvin",
  "Semih",
  "Rico",
  "Mick",
  "Darian",
  "Joost",
  "Tommy",
  "Angelo",
  "Romeo",
  "Keanu",
  "Kurt",
  "Raik",
  "Tammo",
  "Dylan",
  "Nikolai",
  "Thies",
  "Armin",
  "Darius",
  "Maddox",
  "Rasmus"
];

// src/dictionaries/de/firstnames_male_2010_2019.ts
var firstnames_male_2010_2019_default = [
  "Ben",
  "Leon",
  "Paul",
  "Jonas",
  "Finn",
  "Lukas",
  "Louis",
  "Luca",
  "Noah",
  "Elias",
  "Felix",
  "Maximilian",
  "Max",
  "Henry",
  "Julian",
  "Moritz",
  "Tim",
  "Emil",
  "Jakob",
  "Philipp",
  "Niklas",
  "Oskar",
  "David",
  "Anton",
  "Alexander",
  "Liam",
  "Matteo",
  "Theo",
  "Tom",
  "Jan"
];

// src/dictionaries/de/firstnames_male_2020_2029.ts
var firstnames_male_2020_2029_default = [
  "Noah",
  "Matteo",
  "Leon",
  "Elias",
  "Finn",
  "Paul",
  "Luca",
  "Emil",
  "Louis",
  "Theo",
  "Henry",
  "Felix",
  "Ben",
  "Liam",
  "Leo",
  "Lukas",
  "Jonas",
  "Jakob",
  "Anton",
  "Oskar",
  "Maximilian",
  "Mohammed",
  "Levi",
  "Milan",
  "Jona",
  "David",
  "Karl",
  "Jannis",
  "Lio",
  "Moritz",
  "Adam",
  "Max",
  "Samuel",
  "Mats",
  "Alexander",
  "Jonathan",
  "Raphael",
  "Aaron",
  "Linus",
  "Julian",
  "Milo",
  "Theodor",
  "Carlo",
  "Philipp",
  "Valentin",
  "Leonard",
  "Erik",
  "Mika",
  "Johann",
  "Niklas"
];

// src/dictionaries/de/firstnames_female_1950_1959.ts
var firstnames_female_1950_1959_default = [
  "Angelika",
  "Monika",
  "Sabine",
  "Karin",
  "Petra",
  "Gabriele",
  "Birgit",
  "Brigitte",
  "Renate",
  "Susanne",
  "Barbara",
  "Ursula",
  "Ute",
  "Marion",
  "Jutta",
  "Ingrid",
  "Cornelia",
  "Heike",
  "Maria",
  "Regina",
  "Elke",
  "Silvia",
  "Andrea",
  "Ulrike",
  "Gisela",
  "Angela",
  "B\xE4rbel",
  "Christine",
  "Martina",
  "Christiane",
  "Doris",
  "Helga",
  "Dagmar",
  "Sigrid",
  "Christa",
  "Gudrun",
  "Beate",
  "Rita",
  "Hannelore",
  "Marlies",
  "Eva",
  "Claudia",
  "Anke",
  "Marianne",
  "Annette",
  "Elisabeth",
  "Astrid",
  "Erika",
  "Heidi",
  "Christel",
  "Rosemarie",
  "Anna",
  "Bettina",
  "Gabriela",
  "Roswita",
  "Ilona",
  "Annegret",
  "Evelyn",
  "Sonja",
  "Inge",
  "Christina",
  "Carmen",
  "Irene",
  "Kirsten",
  "Lydia",
  "Silke",
  "Marina",
  "Margret",
  "Marita",
  "Ruth",
  "Maren",
  "Sibylle",
  "Waltraud",
  "Ingeborg",
  "Katharina",
  "Vera",
  "Heidemarie",
  "Kerstin",
  "Heidrun",
  "Margrit",
  "Carola",
  "Iris",
  "Antje",
  "Katrin",
  "Margit",
  "Manuela",
  "Veronika",
  "Olga",
  "Anne",
  "Dorothea",
  "Hildegard",
  "Irmgard",
  "Edith",
  "Uta",
  "Regine",
  "Margarete",
  "Anita",
  "Frauke",
  "Karen",
  "Valentina",
  "Anja",
  "Tatjana",
  "Ellen",
  "Edeltraud",
  "Verena",
  "D\xF6rte",
  "Ilse",
  "Gerda",
  "Ines",
  "Britta",
  "Corinna",
  "Elvira",
  "Michaela",
  "Annemarie",
  "Anneliese",
  "Gertrud",
  "Gitta",
  "Marie",
  "Susann",
  "Maike",
  "Stefanie",
  "Danuta",
  "Gunda",
  "Margot",
  "Johanna",
  "Irina",
  "Ina",
  "Theresa",
  "Nina",
  "Wiebke"
];

// src/dictionaries/de/firstnames_female_1960_1969.ts
var firstnames_female_1960_1969_default = [
  "Sabine",
  "Susanne",
  "Petra",
  "Andrea",
  "Claudia",
  "Birgit",
  "Martina",
  "Anja",
  "Heike",
  "Kerstin",
  "Bettina",
  "Gabriele",
  "Katrin",
  "Silke",
  "Ute",
  "Christine",
  "Stefanie",
  "Monika",
  "Britta",
  "Ulrike",
  "Barbara",
  "Kirsten",
  "Silvia",
  "Karin",
  "Annette",
  "Christiane",
  "Beate",
  "Manuela",
  "Angela",
  "Anke",
  "Nicole",
  "Marion",
  "Cornelia",
  "Christina",
  "Angelika",
  "Astrid",
  "Elke",
  "Michaela",
  "Regina",
  "Dagmar",
  "Katja",
  "Brigitte",
  "Maria",
  "Iris",
  "Jutta",
  "Antje",
  "Tanja",
  "Doris",
  "Maike",
  "Simone",
  "Maren",
  "Corinna",
  "Sonja",
  "Daniela",
  "Carola",
  "Alexandra",
  "Eva",
  "Ursula",
  "Carmen",
  "Sandra",
  "Karen",
  "Ines",
  "Marina",
  "Katharina",
  "Elisabeth",
  "B\xE4rbel",
  "Renate",
  "Gaby",
  "Anne",
  "Anna",
  "Gabriela",
  "Sibylle",
  "Heidi",
  "Uta",
  "Ina",
  "Sigrid",
  "Frauke",
  "Ilona",
  "Ingrid",
  "Gudrun",
  "Wiebke",
  "Tatjana",
  "Yvonne",
  "Carolin",
  "Patricia",
  "D\xF6rte",
  "Susann",
  "Birte",
  "Rita",
  "Julia",
  "Irina",
  "Bianca",
  "Nikola",
  "Ilka",
  "Olga",
  "Jeanette",
  "Marlies",
  "Helga",
  "Melanie",
  "Verena",
  "Vera",
  "Regine",
  "Kirstin",
  "Evelyn",
  "Irene",
  "Lydia",
  "Christa",
  "Annett",
  "Marianne",
  "Dorothea",
  "Annegret",
  "Elena",
  "Gisela",
  "Imke",
  "Isabell",
  "Heidrun",
  "Viola",
  "Diana",
  "Esther",
  "Susan",
  "Inga",
  "Judith",
  "Ruth",
  "Cordula",
  "Jacqueline",
  "Kai",
  "Veronika",
  "Carina",
  "Roswita",
  "Constanze",
  "Marita",
  "Natalie",
  "Ramona",
  "Ellen",
  "Erika",
  "Fatma",
  "Nina",
  "Svetlana",
  "Dorothee",
  "Inge",
  "Nadja",
  "Jasmin",
  "Anita",
  "Franziska",
  "Friederike",
  "Marie",
  "Svenja",
  "Jessica",
  "Natascha",
  "Rosemarie",
  "Valentina",
  "Ayse",
  "Linda",
  "Beatrix",
  "Johanna",
  "Ariane",
  "Gesa",
  "Larissa",
  "Malgorzata",
  "Miriam",
  "Gunda",
  "Margarete",
  "Natalia",
  "Almut",
  "Ewa",
  "Gitta",
  "Jolanta",
  "Babette",
  "Beatrice",
  "Christel",
  "Christin",
  "Sabrina",
  "Dorit",
  "Jana",
  "Juliane",
  "Hilke",
  "Margret",
  "Beata",
  "Galina",
  "Liane",
  "Danuta",
  "Elvira",
  "Ingeborg",
  "Rosa",
  "Emine",
  "Grit",
  "Hannah",
  "Sabina",
  "Agnes",
  "Edith",
  "Gundula",
  "Inken",
  "Maja",
  "Margit",
  "Bozena",
  "Helena",
  "Theresa",
  "Elzbieta",
  "Hannelore",
  "Tina"
];

// src/dictionaries/de/firstnames_female_1970_1979.ts
var firstnames_female_1970_1979_default = [
  "Nicole",
  "Stefanie",
  "Sandra",
  "Katrin",
  "Claudia",
  "Tanja",
  "Anja",
  "Melanie",
  "Andrea",
  "Daniela",
  "Julia",
  "Susanne",
  "Katja",
  "Christina",
  "Kerstin",
  "Silke",
  "Sabine",
  "Alexandra",
  "Yvonne",
  "Sonja",
  "Nadine",
  "Nina",
  "Simone",
  "Maike",
  "Petra",
  "Christine",
  "Britta",
  "Martina",
  "Anna",
  "Michaela",
  "Manuela",
  "Bianca",
  "Katharina",
  "Silvia",
  "Bettina",
  "Heike",
  "Ulrike",
  "Birgit",
  "Anke",
  "Christiane",
  "Jessica",
  "Monika",
  "Maren",
  "Eva",
  "Anne",
  "Antje",
  "Diana",
  "Jana",
  "Cornelia",
  "Wiebke",
  "Kirsten",
  "Miriam",
  "Tina",
  "Carolin",
  "Astrid",
  "Annette",
  "Maria",
  "Annika",
  "Jennifer",
  "Tatjana",
  "Angela",
  "Corinna",
  "Barbara",
  "Verena",
  "Elena",
  "Jasmin",
  "Birte",
  "Inga",
  "Olga",
  "Natalie",
  "Ines",
  "Iris",
  "Ina",
  "Marion",
  "Beate",
  "Irina",
  "Svenja",
  "Judith",
  "Carina",
  "Sarah",
  "Patricia",
  "Karin",
  "Carmen",
  "Franziska",
  "Janine",
  "Juliane",
  "Saskia",
  "Carola",
  "Doreen",
  "Frauke",
  "Marina",
  "Ute",
  "Isabell",
  "Annett",
  "Christin",
  "Karen",
  "Mandy",
  "Nadja",
  "Svetlana",
  "Natalia",
  "Gabriele",
  "Sabrina",
  "Elke",
  "Ramona",
  "Natascha",
  "Friederike",
  "Ilka",
  "Vanessa",
  "Dagmar",
  "Imke",
  "Jeanette",
  "D\xF6rte",
  "Angelika",
  "Nikola",
  "Rebecca",
  "Regina",
  "Janina",
  "Kirstin",
  "Johanna",
  "Jutta",
  "Elisabeth",
  "Anita",
  "Mareike",
  "Sibylle",
  "Maja",
  "Esther",
  "Vera",
  "Agnieszka",
  "Jenny",
  "Peggy",
  "Ariane",
  "Hannah",
  "Steffi",
  "Joana",
  "Victoria",
  "Magdalena",
  "Fatma",
  "Lena",
  "Sina",
  "Doris",
  "Uta",
  "Larissa",
  "Marie",
  "Evelyn",
  "Ann",
  "Constanze",
  "Jacqueline",
  "Kati",
  "Lydia",
  "Agnes",
  "Dana",
  "Dorothea",
  "Ilona",
  "Kim",
  "Ayse",
  "Gaby",
  "Katarzyna",
  "Mirja",
  "Pamela",
  "Heidi",
  "Helena",
  "Viola",
  "Isabella",
  "Susann",
  "Cindy",
  "Cordula",
  "Emine",
  "Kathleen",
  "Nancy",
  "Beata",
  "Denise",
  "Susan",
  "Ursula",
  "Veronika",
  "Brigitte",
  "Gesa",
  "Martha",
  "Mirjam",
  "Beatrice",
  "Hatice",
  "Dorothee",
  "Linda",
  "Malgorzata",
  "Pia",
  "Grit",
  "Irene",
  "Filiz",
  "Yasemin",
  "Berit",
  "Ellen",
  "Janet",
  "Laura",
  "Lisa",
  "Renate",
  "Ruth",
  "Ewa",
  "Gabriela",
  "Ingrid",
  "Liane",
  "Mariam",
  "Monique",
  "Tamara",
  "Antonia",
  "Svantje",
  "Alice",
  "Margarete",
  "Nele",
  "Manja",
  "Nora",
  "Oksana",
  "\xD6zlem",
  "Nadia",
  "Ricarda",
  "B\xE4rbel",
  "Carolina",
  "H\xFClya",
  "Inken",
  "Rita",
  "Sophie",
  "Valentina",
  "Violetta",
  "Vivien",
  "Britt",
  "Inna",
  "Leyla",
  "Arzu",
  "Kai",
  "Natalja",
  "Sandy",
  "Silvana",
  "Sophia",
  "Beatrix",
  "Ludmilla",
  "Romy",
  "Selma",
  "Elvira",
  "Helene",
  "Henrike",
  "Oxana",
  "Rabea",
  "Sabina",
  "Wenke",
  "Annegret",
  "Aylin",
  "Charlotte",
  "Dorit",
  "Emma",
  "Jeannine",
  "Marianne",
  "Mona"
];

// src/dictionaries/de/firstnames_female_1980_1989.ts
var firstnames_female_1980_1989_default = [
  "Julia",
  "Stefanie",
  "Anna",
  "Katharina",
  "Katrin",
  "Sarah",
  "Sandra",
  "Nadine",
  "Melanie",
  "Christina",
  "Jennifer",
  "Nicole",
  "Sabrina",
  "Jessica",
  "Annika",
  "Claudia",
  "Nina",
  "Anne",
  "Daniela",
  "Franziska",
  "Anja",
  "Carolin",
  "Jasmin",
  "Christin",
  "Katja",
  "Janina",
  "Jana",
  "Janine",
  "Yvonne",
  "Alexandra",
  "Svenja",
  "Maike",
  "Lena",
  "Laura",
  "Maria",
  "Tanja",
  "Susanne",
  "Lisa",
  "Andrea",
  "Christine",
  "Miriam",
  "Sonja",
  "Johanna",
  "Ann",
  "Sabine",
  "Vanessa",
  "Kerstin",
  "Natalie",
  "Bianca",
  "Eva",
  "Mareike",
  "Marie",
  "Verena",
  "Jacqueline",
  "Isabell",
  "Hannah",
  "Saskia",
  "Simone",
  "Tina",
  "Juliane",
  "Maren",
  "Elena",
  "Rebecca",
  "Martina",
  "Christiane",
  "Carina",
  "Mandy",
  "Olga",
  "Denise",
  "Wiebke",
  "Diana",
  "Marina",
  "Tatjana",
  "Jenny",
  "Manuela",
  "Linda",
  "Michaela",
  "Nadja",
  "Inga",
  "Antje",
  "Corinna",
  "Patricia",
  "Silvia",
  "Ulrike",
  "Kim",
  "Judith",
  "Ines",
  "Monika",
  "Birte",
  "Ina",
  "Victoria",
  "Elisabeth",
  "Theresa",
  "Sina",
  "Irina",
  "Sophie",
  "Silke",
  "Friederike",
  "Britta",
  "Nora",
  "Lea",
  "Nele",
  "Natascha",
  "Bettina",
  "Doreen",
  "Barbara",
  "Angela",
  "Ramona",
  "Cornelia",
  "Anke",
  "Natalia",
  "Magdalena",
  "Nancy",
  "Annette",
  "Astrid",
  "Aylin",
  "Susann",
  "Kathleen",
  "Alina",
  "Lydia",
  "Joana",
  "Kirsten",
  "Jeanette",
  "Martha",
  "Heike",
  "Mona",
  "Anita",
  "Dana",
  "Veronika",
  "Yasemin",
  "Sophia",
  "Carolina",
  "Svetlana",
  "Esther",
  "Charlotte",
  "Antonia",
  "Constanze",
  "Vivien",
  "Luisa",
  "Svantje",
  "Helena",
  "Petra",
  "Steffi",
  "Pia",
  "Susan",
  "Monique",
  "Lina",
  "Mariam",
  "Vera",
  "Merle",
  "Angelika",
  "Karin",
  "Maja",
  "Frauke",
  "Agnes",
  "Isabella",
  "Josephine",
  "Frederike",
  "Michelle",
  "Carmen",
  "Carola",
  "Cindy",
  "Madeleine",
  "Janna",
  "Larissa",
  "Gina",
  "Marlene",
  "Anastasia",
  "Elisa",
  "Regina",
  "Viola",
  "\xD6zlem",
  "Alice",
  "Evelyn",
  "Marleen",
  "Dominique",
  "Lara",
  "Karen",
  "Nikola",
  "Marion",
  "Annabell",
  "Annett",
  "Dorothea",
  "Iris",
  "Henrike",
  "Kira",
  "Mirja",
  "Camilla",
  "Ronja",
  "Valentina",
  "Alena",
  "Ariane",
  "Dorothee",
  "Fatma",
  "Gesa",
  "Agnieszka",
  "Birgit",
  "Ricarda",
  "Sandy",
  "Beate"
];

// src/dictionaries/de/firstnames_female_1990_1999.ts
var firstnames_female_1990_1999_default = [
  "Julia",
  "Anna",
  "Sarah",
  "Lisa",
  "Laura",
  "Katharina",
  "Lena",
  "Vanessa",
  "Annika",
  "Jennifer",
  "Jana",
  "Lea",
  "Marie",
  "Jasmin",
  "Franziska",
  "Hannah",
  "Jessica",
  "Michelle",
  "Nina",
  "Alina",
  "Johanna",
  "Carolin",
  "Christina",
  "Kim",
  "Nadine",
  "Jacqueline",
  "Ann",
  "Luisa",
  "Sophie",
  "Lara",
  "Natalie",
  "Svenja",
  "Sabrina",
  "Isabell",
  "Sandra",
  "Janina",
  "Melanie",
  "Leonie",
  "Antonia",
  "Saskia",
  "Stefanie",
  "Aylin",
  "Denise",
  "Nele",
  "Pia",
  "Alexandra",
  "Katrin",
  "Sophia",
  "Sina",
  "Melina",
  "Janine",
  "Vivien",
  "Rebecca",
  "Anne",
  "Miriam",
  "Victoria",
  "Nicole",
  "Mareike",
  "Lina",
  "Josephine",
  "Merle",
  "Clara",
  "Maria",
  "Maike",
  "Charlotte",
  "Celina",
  "Paula",
  "Carina",
  "Larissa",
  "Christin",
  "Linda",
  "Mandy",
  "Theresa",
  "Kimberly",
  "Elena",
  "Melissa",
  "Jule",
  "Celine",
  "Daniela",
  "Jenny",
  "Kira",
  "Patricia",
  "Ronja",
  "Bianca",
  "Eva",
  "Sonja",
  "Joana",
  "Gina",
  "Tanja",
  "Nora",
  "Yvonne",
  "Pauline",
  "Emily",
  "Natascha",
  "Anja",
  "Marina",
  "Friederike",
  "Angelina",
  "Nadja",
  "Paulina",
  "Lynn",
  "Alicia",
  "Svea",
  "Amelie",
  "Katja",
  "Juliane",
  "Lilly",
  "Marlene",
  "Verena",
  "Chantal",
  "Milena",
  "Maja",
  "Chiara",
  "Selina",
  "Alena",
  "Carlotta",
  "Mona",
  "Annabell",
  "Carla",
  "Claudia",
  "Tatjana",
  "Maren",
  "Elisabeth",
  "Emma",
  "Helena",
  "Inga",
  "Luise",
  "Tamara",
  "Christine",
  "Fiona",
  "Judith",
  "Frederike",
  "Finja",
  "Jill",
  "Fenja",
  "Tina",
  "Cindy",
  "Ina",
  "Janne",
  "Marleen",
  "Mia",
  "Samantha",
  "Annalena",
  "Janika",
  "Henrike",
  "Wiebke",
  "Elisa",
  "Esther",
  "Ricarda",
  "Janna",
  "Stella",
  "Carolina",
  "Dana",
  "Helen",
  "Madeleine",
  "Mara",
  "Simone",
  "Corinna",
  "Diana",
  "Fabienne",
  "Monique",
  "Samira",
  "Sandy",
  "Tabea",
  "Valerie",
  "Malin",
  "Andrea",
  "Birte",
  "Swantje",
  "Veronika",
  "Kerstin",
  "Magdalena",
  "Ramona",
  "Susanne",
  "Greta",
  "Juli",
  "Kaja",
  "Lucy",
  "Zoe",
  "Angelique",
  "Jasmina",
  "Tessa",
  "Lydia",
  "Sabine",
  "Dominique",
  "Malina",
  "Michaela",
  "Charline",
  "Monika",
  "Karen",
  "Mira",
  "Yasemin",
  "Alica",
  "Alice",
  "Alisa",
  "Angelika",
  "Emilia",
  "Henriette",
  "Marieke",
  "Vera",
  "Anneke",
  "Felicia",
  "Giulia",
  "Liza",
  "Maxi",
  "Viola",
  "Annkatrin",
  "Lotta",
  "Olivia",
  "Anastasia",
  "Dilara",
  "Felicitas",
  "Mariam",
  "Marisa",
  "Rieke",
  "Rosa",
  "Beatrice",
  "Constanze",
  "Dorothea",
  "Isabella",
  "Juliana",
  "Katerina",
  "Martina",
  "Merve",
  "Philine",
  "Valentina",
  "Justine",
  "Melisa",
  "Michele",
  "Mika",
  "Nancy",
  "Selin",
  "Alissa",
  "Angela",
  "Cara",
  "Charleen",
  "Deborah",
  "Ellen",
  "Imke",
  "Irina",
  "Jeanette",
  "Leona",
  "Lorena",
  "Manuela",
  "Martha",
  "Silvia",
  "Viviane",
  "Aline",
  "Desiree",
  "Xenia"
];

// src/dictionaries/de/firstnames_female_2000_2009.ts
var firstnames_female_2000_2009_default = [
  "Hannah",
  "Leonie",
  "Anna",
  "Lea",
  "Lena",
  "Mia",
  "Emily",
  "Laura",
  "Lara",
  "Sarah",
  "Emma",
  "Lilly",
  "Marie",
  "Sophie",
  "Nele",
  "Johanna",
  "Lina",
  "Julia",
  "Maja",
  "Sophia",
  "Lisa",
  "Amelie",
  "Alina",
  "Luisa",
  "Leni",
  "Clara",
  "Jana",
  "Charlotte",
  "Paula",
  "Emilia",
  "Jasmin",
  "Zoe",
  "Annika",
  "Katharina",
  "Chiara",
  "Pia",
  "Finja",
  "Josephine",
  "Angelina",
  "Jule",
  "Lucy",
  "Melina",
  "Antonia",
  "Vanessa",
  "Emely",
  "Victoria",
  "Celina",
  "Michelle",
  "Nina",
  "Isabell",
  "Franziska",
  "Fiona",
  "Amy",
  "Celine",
  "Maria",
  "Pauline",
  "Stella",
  "Carolin",
  "Lia",
  "Marlene",
  "Melissa",
  "Ida",
  "Greta",
  "Selina",
  "Helena",
  "Aylin",
  "Merle",
  "Ronja",
  "Sina",
  "Vivien",
  "Mara",
  "Eva",
  "Kim",
  "Elisa",
  "Theresa",
  "Jolina",
  "Mathilda",
  "Jette",
  "Lotta",
  "Luise",
  "Elena",
  "Carla",
  "Jessica",
  "Larissa",
  "Luna",
  "Nelly",
  "Alicia",
  "Lana",
  "Linda",
  "Milena",
  "Miriam",
  "Samira",
  "Frieda",
  "Magdalena",
  "Carlotta",
  "Alexandra",
  "Fabienne",
  "Kira",
  "Helene",
  "Nora",
  "Elisabeth",
  "Natalie",
  "Tabea",
  "Romy",
  "Anne",
  "Paulina",
  "Juli",
  "Christina",
  "Annalena",
  "Kimberly",
  "Samantha",
  "Annabell",
  "Ella",
  "Lynn",
  "Mira",
  "Letizia",
  "Jennifer",
  "Carina",
  "Aaliyah",
  "Rebecca",
  "Anastasia",
  "Dana",
  "Isabella",
  "Diana",
  "Olivia",
  "Lenja",
  "Mariella",
  "Mila",
  "Lucia",
  "Martha",
  "Leyla",
  "Joana",
  "Elina",
  "Carolina",
  "Xenia",
  "Gina",
  "Nicole",
  "Janina",
  "Saskia",
  "Evelyn",
  "Anni",
  "Marleen",
  "Melanie",
  "Svenja",
  "Svea",
  "Chantal",
  "Tessa",
  "Maike",
  "Fenja",
  "Leona",
  "Josie",
  "Joline",
  "Cheyenne",
  "Lorena",
  "Noemi",
  "Helen",
  "Ann",
  "Alissa",
  "Malin",
  "Lilian",
  "Lotte",
  "Mina",
  "Felicitas",
  "Liv",
  "Jenny",
  "Jill",
  "Valentina",
  "Veronika",
  "Alexa",
  "Kaja",
  "Rieke",
  "Yara",
  "Dilara",
  "Tuana",
  "Laila",
  "Tamara",
  "Alisa",
  "Ela",
  "Marina",
  "Alessia",
  "Luana",
  "Patricia",
  "Lene",
  "Jacqueline",
  "Janne",
  "Henriette",
  "Ashley",
  "Franka",
  "Milla",
  "Florentine",
  "Selin",
  "Selma",
  "Giulia",
  "Mona",
  "Lisann",
  "Aleyna",
  "Rosalie",
  "Sonja",
  "Elif",
  "Thea",
  "Maren",
  "Enya",
  "Nadine",
  "Alisha",
  "Freya",
  "Jamie",
  "Denise",
  "Aurelia",
  "Ina",
  "Christin",
  "Judith",
  "Lilith",
  "Alena",
  "Felicia",
  "Juliana",
  "Sandra",
  "Zoey",
  "Linnea",
  "Soraya",
  "Nisa",
  "Stefanie",
  "Juliane",
  "Daria",
  "Jasmina",
  "Josefin",
  "Friederike",
  "Marla",
  "Rosa",
  "Cara",
  "Nika",
  "Naomi",
  "Vivian",
  "Amina",
  "Elli",
  "Cora",
  "Luca",
  "Madita",
  "Mailin",
  "Marieke",
  "Tara",
  "Amira",
  "Liana",
  "Lydia",
  "Joy",
  "Madlen",
  "Nike",
  "Hailey",
  "Madeleine",
  "Mareike",
  "Aimee",
  "Cassandra",
  "Heidi",
  "Joyce",
  "Alea",
  "Janine",
  "Jonna",
  "Sydney",
  "Alia",
  "Ilayda",
  "Livia",
  "Maira",
  "Leana",
  "Valerie",
  "Thalia",
  "Ellen",
  "Emmi",
  "Melisa",
  "Inga",
  "Julina",
  "Smilla",
  "Katja",
  "Melinda",
  "Valeria",
  "Anouk",
  "Liliana",
  "Sabrina",
  "Wiebke",
  "Joleen",
  "Leandra",
  "Zeynep",
  "Katrin",
  "Tamina",
  "Jenna",
  "Levke",
  "Salome",
  "Annelie",
  "Cecilia",
  "Annemarie",
  "Jona",
  "Mary",
  "Mirja",
  "Collien",
  "Alice",
  "Azra",
  "Ceylin",
  "Lavinia",
  "Maxi",
  "Anja",
  "Henrike",
  "Mariam"
];

// src/dictionaries/de/firstnames_female_2010_2019.ts
var firstnames_female_2010_2019_default = [
  "Mia",
  "Emma",
  "Hannah",
  "Sophia",
  "Emilia",
  "Anna",
  "Lea",
  "Lina",
  "Marie",
  "Lena",
  "Leonie",
  "Emily",
  "Amelie",
  "Luisa",
  "Johanna",
  "Clara",
  "Sophie",
  "Lilly",
  "Mila",
  "Leni",
  "Laura",
  "Lara",
  "Nele",
  "Maja",
  "Charlotte",
  "Sarah",
  "Ella",
  "Ida",
  "Mathilda",
  "Frieda"
];

// src/dictionaries/de/firstnames_female_2020_2029.ts
var firstnames_female_2020_2029_default = [
  "Emilia",
  "Sophia",
  "Emma",
  "Hannah",
  "Mia",
  "Lina",
  "Mila",
  "Ella",
  "Clara",
  "Lea",
  "Marie",
  "Leni",
  "Lia",
  "Mathilda",
  "Ida",
  "Anna",
  "Frieda",
  "Leonie",
  "Emily",
  "Maja",
  "Lilly",
  "Luisa",
  "Charlotte",
  "Amelie",
  "Sophie",
  "Lena",
  "Johanna",
  "Lara",
  "Mira",
  "Nora",
  "Nele",
  "Sarah",
  "Malia",
  "Lotta",
  "Juna",
  "Paula",
  "Luna",
  "Elisa",
  "Maria",
  "Romy",
  "Laura",
  "Helena",
  "Thea",
  "Mara",
  "Victoria",
  "Antonia",
  "Elena",
  "Tilda",
  "Carla",
  "Eva"
];

// src/implementations/IdentityGeneratorDe.ts
var IdentityGeneratorDe = class extends IdentityGenerator {
  /**
   * Get the male first names (generic fallback - empty as we use decade-based).
   */
  getFirstNamesMaleJson() {
    return [];
  }
  /**
   * Get the female first names (generic fallback - empty as we use decade-based).
   */
  getFirstNamesFemaleJson() {
    return [];
  }
  /**
   * Get the last names.
   */
  getLastNamesJson() {
    return lastnames_default3;
  }
  /**
   * Get decade-based male first names.
   * Each range covers a specific decade with names popular during that period.
   */
  getFirstNamesMaleByDecade() {
    return [
      { startYear: 1950, endYear: 1959, names: firstnames_male_1950_1959_default },
      { startYear: 1960, endYear: 1969, names: firstnames_male_1960_1969_default },
      { startYear: 1970, endYear: 1979, names: firstnames_male_1970_1979_default },
      { startYear: 1980, endYear: 1989, names: firstnames_male_1980_1989_default },
      { startYear: 1990, endYear: 1999, names: firstnames_male_1990_1999_default },
      { startYear: 2e3, endYear: 2009, names: firstnames_male_2000_2009_default },
      { startYear: 2010, endYear: 2019, names: firstnames_male_2010_2019_default },
      { startYear: 2020, endYear: 2029, names: firstnames_male_2020_2029_default }
    ];
  }
  /**
   * Get decade-based female first names.
   * Each range covers a specific decade with names popular during that period.
   */
  getFirstNamesFemaleByDecade() {
    return [
      { startYear: 1950, endYear: 1959, names: firstnames_female_1950_1959_default },
      { startYear: 1960, endYear: 1969, names: firstnames_female_1960_1969_default },
      { startYear: 1970, endYear: 1979, names: firstnames_female_1970_1979_default },
      { startYear: 1980, endYear: 1989, names: firstnames_female_1980_1989_default },
      { startYear: 1990, endYear: 1999, names: firstnames_female_1990_1999_default },
      { startYear: 2e3, endYear: 2009, names: firstnames_female_2000_2009_default },
      { startYear: 2010, endYear: 2019, names: firstnames_female_2010_2019_default },
      { startYear: 2020, endYear: 2029, names: firstnames_female_2020_2029_default }
    ];
  }
};

// src/utils/IdentityHelperUtils.ts
var IdentityHelperUtils = class {
  /**
   * Normalize a birth date for display.
   */
  static normalizeBirthDateForDisplay(birthDate) {
    if (!birthDate || birthDate.startsWith("0001-01-01")) {
      return "";
    }
    return birthDate.split(/[T ]/)[0];
  }
  /**
   * Normalize a birth date for database storage.
   * Converts any date format to the standard format: "yyyy-MM-dd 00:00:00" (19 characters).
   * BirthDate fields do not include time or milliseconds, just date with 00:00:00.
   */
  static normalizeBirthDateForDb(input) {
    if (!input || input.trim() === "") {
      return "0001-01-01 00:00:00";
    }
    const trimmed = input.trim();
    const match = trimmed.match(/^(\d{4})-(\d{2})-(\d{2})/);
    if (match) {
      const [_, y, m, d] = match;
      return `${y}-${m}-${d} 00:00:00`;
    }
    const parsedDate = new Date(trimmed);
    if (!isNaN(parsedDate.getTime())) {
      const year = parsedDate.getFullYear().toString().padStart(4, "0");
      const month = (parsedDate.getMonth() + 1).toString().padStart(2, "0");
      const day = parsedDate.getDate().toString().padStart(2, "0");
      return `${year}-${month}-${day} 00:00:00`;
    }
    return "0001-01-01 00:00:00";
  }
  /**
   * Check if a birth date is valid.
   */
  static isValidBirthDate(input) {
    if (!input || input.trim() === "") {
      return false;
    }
    if (input.startsWith("0001-01-01")) {
      return false;
    }
    const date = new Date(input);
    if (isNaN(date.getTime())) {
      return false;
    }
    const yearValid = date.getFullYear() > 1 && date.getFullYear() < 9999;
    return yearValid;
  }
};

// src/utils/AgeRangeConverter.ts
function getAvailableAgeRanges() {
  return [
    { value: "random", label: "Random" },
    { value: "21-25", label: "21-25" },
    { value: "26-30", label: "26-30" },
    { value: "31-35", label: "31-35" },
    { value: "36-40", label: "36-40" },
    { value: "41-45", label: "41-45" },
    { value: "46-50", label: "46-50" },
    { value: "51-55", label: "51-55" },
    { value: "56-60", label: "56-60" },
    { value: "61-65", label: "61-65" }
  ];
}
function convertAgeRangeToBirthdateOptions(ageRange) {
  if (ageRange === "random" || !ageRange) {
    return null;
  }
  const parts = ageRange.split("-");
  if (parts.length !== 2) {
    return null;
  }
  const minAge = parseInt(parts[0], 10);
  const maxAge = parseInt(parts[1], 10);
  if (isNaN(minAge) || isNaN(maxAge)) {
    return null;
  }
  const currentYear = (/* @__PURE__ */ new Date()).getFullYear();
  const middleAge = Math.floor((minAge + maxAge) / 2);
  const targetYear = currentYear - middleAge;
  const yearDeviation = Math.floor((maxAge - minAge) / 2);
  return { targetYear, yearDeviation };
}

// src/utils/LanguageProvider.ts
function getAvailableLanguages() {
  return [
    {
      value: "en",
      label: "English",
      flag: "\u{1F1EC}\u{1F1E7}",
      alternativeCodes: ["en-US", "en-GB", "en-CA", "en-AU", "en-NZ", "en-IE", "en-ZA", "en-SG", "en-IN"]
    },
    {
      value: "nl",
      label: "Nederlands",
      flag: "\u{1F1F3}\u{1F1F1}",
      alternativeCodes: ["nl-NL", "nl-BE"]
    },
    {
      value: "de",
      label: "Deutsch",
      flag: "\u{1F1E9}\u{1F1EA}",
      alternativeCodes: ["de-DE", "de-AT", "de-CH", "de-LU", "de-LI"]
    }
  ];
}
function mapUiLanguageToIdentityLanguage(uiLanguageCode) {
  if (!uiLanguageCode) {
    return null;
  }
  const normalizedCode = uiLanguageCode.toLowerCase();
  const availableLanguages = getAvailableLanguages();
  const exactMatch = availableLanguages.find((lang) => lang.value.toLowerCase() === normalizedCode);
  if (exactMatch) {
    return exactMatch.value;
  }
  const alternativeMatch = availableLanguages.find(
    (lang) => lang.alternativeCodes?.some((code) => code.toLowerCase() === normalizedCode)
  );
  if (alternativeMatch) {
    return alternativeMatch.value;
  }
  const baseCode = normalizedCode.split("-")[0];
  const baseMatch = availableLanguages.find((lang) => lang.value.toLowerCase() === baseCode);
  if (baseMatch) {
    return baseMatch.value;
  }
  return null;
}

// src/factories/IdentityGeneratorFactory.ts
var CreateIdentityGenerator = (language) => {
  switch (language.toLowerCase()) {
    case "en":
      return new IdentityGeneratorEn();
    case "nl":
      return new IdentityGeneratorNl();
    case "de":
      return new IdentityGeneratorDe();
    default:
      console.warn(`Language '${language}' is not supported. Falling back to English.`);
      return new IdentityGeneratorEn();
  }
};

// src/factories/UsernameEmailGeneratorFactory.ts
var CreateUsernameEmailGenerator = () => {
  return new UsernameEmailGenerator();
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CreateIdentityGenerator,
  CreateUsernameEmailGenerator,
  Gender,
  IdentityGenerator,
  IdentityGeneratorDe,
  IdentityGeneratorEn,
  IdentityGeneratorNl,
  IdentityHelperUtils,
  UsernameEmailGenerator,
  convertAgeRangeToBirthdateOptions,
  getAvailableAgeRanges,
  getAvailableLanguages,
  mapUiLanguageToIdentityLanguage
});
