// <auto-generated>
// This file was automatically generated. Do not edit manually.


// src/vault/FieldKey.ts
var FieldKey = {
  /**
   * Login username field
   * Type: Text
   */
  LoginUsername: "login.username",
  /**
   * Login password field
   * Type: Password
   */
  LoginPassword: "login.password",
  /**
   * Login email field
   * Type: Email
   */
  LoginEmail: "login.email",
  /**
   * Login URL field (multi-value)
   * Type: URL
   */
  LoginUrl: "login.url",
  /**
   * Credit card number field
   * Type: Text
   */
  CardNumber: "card.number",
  /**
   * Credit card cardholder name field
   * Type: Text
   */
  CardCardholderName: "card.cardholder_name",
  /**
   * Credit card expiry month field
   * Type: Text
   */
  CardExpiryMonth: "card.expiry_month",
  /**
   * Credit card expiry year field
   * Type: Text
   */
  CardExpiryYear: "card.expiry_year",
  /**
   * Credit card CVV field
   * Type: Password
   */
  CardCvv: "card.cvv",
  /**
   * Credit card PIN field
   * Type: Password
   */
  CardPin: "card.pin",
  /**
   * Alias first name field
   * Type: Text
   */
  AliasFirstName: "alias.first_name",
  /**
   * Alias last name field
   * Type: Text
   */
  AliasLastName: "alias.last_name",
  /**
   * Alias gender field
   * Type: Text
   */
  AliasGender: "alias.gender",
  /**
   * Alias birth date field
   * Type: Date
   */
  AliasBirthdate: "alias.birthdate",
  /**
   * Notes content field
   * Type: TextArea
   */
  NotesContent: "notes.content"
};

// src/vault/Item.ts
var ItemTypes = {
  Login: "Login",
  Alias: "Alias",
  CreditCard: "CreditCard",
  Note: "Note"
};
var FieldTypes = {
  Text: "Text",
  Password: "Password",
  Hidden: "Hidden",
  Email: "Email",
  URL: "URL",
  Date: "Date",
  Number: "Number",
  Phone: "Phone",
  TextArea: "TextArea"
};

// src/vault/SystemFieldRegistry.ts
var FieldCategories = {
  Primary: "Primary",
  Login: "Login",
  Alias: "Alias",
  Card: "Card",
  Custom: "Custom",
  Notes: "Notes",
  Metadata: "Metadata"
};
var SystemFieldRegistry = {
  /* =================== LOGIN FIELDS =================== */
  "login.email": {
    FieldKey: "login.email",
    FieldType: "Email",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      Login: { ShowByDefault: false },
      Alias: { ShowByDefault: true }
    },
    EnableHistory: true,
    Category: FieldCategories.Login,
    DefaultDisplayOrder: 10
  },
  "login.username": {
    FieldKey: "login.username",
    FieldType: "Text",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      Login: { ShowByDefault: true },
      Alias: { ShowByDefault: true }
    },
    EnableHistory: true,
    Category: FieldCategories.Login,
    DefaultDisplayOrder: 15
  },
  "login.password": {
    FieldKey: "login.password",
    FieldType: "Password",
    IsHidden: true,
    IsMultiValue: false,
    ApplicableToTypes: {
      Login: { ShowByDefault: true },
      Alias: { ShowByDefault: true }
    },
    EnableHistory: true,
    Category: FieldCategories.Login,
    DefaultDisplayOrder: 20
  },
  "login.url": {
    FieldKey: "login.url",
    FieldType: "URL",
    IsHidden: false,
    IsMultiValue: true,
    ApplicableToTypes: {
      Login: { ShowByDefault: true },
      Alias: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Primary,
    DefaultDisplayOrder: 5
  },
  /* =================== ALIAS FIELDS =================== */
  "alias.first_name": {
    FieldKey: "alias.first_name",
    FieldType: "Text",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      Alias: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Alias,
    DefaultDisplayOrder: 20
  },
  "alias.last_name": {
    FieldKey: "alias.last_name",
    FieldType: "Text",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      Alias: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Alias,
    DefaultDisplayOrder: 30
  },
  "alias.gender": {
    FieldKey: "alias.gender",
    FieldType: "Text",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      Alias: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Alias,
    DefaultDisplayOrder: 50
  },
  "alias.birthdate": {
    FieldKey: "alias.birthdate",
    FieldType: "Date",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      Alias: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Alias,
    DefaultDisplayOrder: 60
  },
  /* =================== CREDIT CARD FIELDS =================== */
  "card.cardholder_name": {
    FieldKey: "card.cardholder_name",
    FieldType: "Text",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      CreditCard: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Card,
    DefaultDisplayOrder: 10
  },
  "card.number": {
    FieldKey: "card.number",
    FieldType: "Hidden",
    IsHidden: true,
    IsMultiValue: false,
    ApplicableToTypes: {
      CreditCard: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Card,
    DefaultDisplayOrder: 20
  },
  "card.expiry_month": {
    FieldKey: "card.expiry_month",
    FieldType: "Text",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      CreditCard: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Card,
    DefaultDisplayOrder: 30
  },
  "card.expiry_year": {
    FieldKey: "card.expiry_year",
    FieldType: "Text",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      CreditCard: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Card,
    DefaultDisplayOrder: 40
  },
  "card.cvv": {
    FieldKey: "card.cvv",
    FieldType: "Hidden",
    IsHidden: true,
    IsMultiValue: false,
    ApplicableToTypes: {
      CreditCard: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Card,
    DefaultDisplayOrder: 50
  },
  "card.pin": {
    FieldKey: "card.pin",
    FieldType: "Hidden",
    IsHidden: true,
    IsMultiValue: false,
    ApplicableToTypes: {
      CreditCard: { ShowByDefault: false }
    },
    EnableHistory: false,
    Category: FieldCategories.Card,
    DefaultDisplayOrder: 60
  },
  /* =================== NOTES FIELDS =================== */
  "notes.content": {
    FieldKey: "notes.content",
    FieldType: "TextArea",
    IsHidden: false,
    IsMultiValue: false,
    ApplicableToTypes: {
      Login: { ShowByDefault: false },
      Alias: { ShowByDefault: false },
      CreditCard: { ShowByDefault: false },
      Note: { ShowByDefault: true }
    },
    EnableHistory: false,
    Category: FieldCategories.Notes,
    DefaultDisplayOrder: 100
  }
};
function getSystemField(fieldKey) {
  return SystemFieldRegistry[fieldKey];
}
function isSystemField(fieldKey) {
  return fieldKey in SystemFieldRegistry;
}
function fieldAppliesToType(field, itemType) {
  return itemType in field.ApplicableToTypes;
}
function getFieldConfigForType(field, itemType) {
  return field.ApplicableToTypes[itemType];
}
function isFieldShownByDefault(field, itemType) {
  const config = field.ApplicableToTypes[itemType];
  return config?.ShowByDefault ?? false;
}
function getSystemFieldsForItemType(itemType) {
  return Object.values(SystemFieldRegistry).filter((field) => fieldAppliesToType(field, itemType)).sort((a, b) => a.DefaultDisplayOrder - b.DefaultDisplayOrder);
}
function getDefaultFieldsForItemType(itemType) {
  return Object.values(SystemFieldRegistry).filter((field) => isFieldShownByDefault(field, itemType)).sort((a, b) => a.DefaultDisplayOrder - b.DefaultDisplayOrder);
}
function getOptionalFieldsForItemType(itemType) {
  return Object.values(SystemFieldRegistry).filter((field) => fieldAppliesToType(field, itemType) && !isFieldShownByDefault(field, itemType)).sort((a, b) => a.DefaultDisplayOrder - b.DefaultDisplayOrder);
}
function getAllSystemFieldKeys() {
  return Object.keys(SystemFieldRegistry);
}
function isSystemFieldPrefix(fieldKey) {
  return fieldKey.startsWith("login.") || fieldKey.startsWith("alias.") || fieldKey.startsWith("card.") || fieldKey.startsWith("notes.");
}

// src/vault/ItemMethods.ts
function getFieldValue(item, fieldKey) {
  const field = item.Fields.find((f) => f.FieldKey === fieldKey);
  if (!field) {
    return void 0;
  }
  return Array.isArray(field.Value) ? field.Value[0] : field.Value;
}
function getFieldValues(item, fieldKey) {
  const field = item.Fields.find((f) => f.FieldKey === fieldKey);
  if (!field) {
    return [];
  }
  return Array.isArray(field.Value) ? field.Value : [field.Value];
}
function hasField(item, fieldKey) {
  const value = getFieldValue(item, fieldKey);
  return value !== void 0 && value !== "";
}
function groupFields(item, grouper) {
  const groups = {};
  item.Fields.forEach((field) => {
    const group = grouper(field);
    if (!groups[group]) {
      groups[group] = [];
    }
    groups[group].push(field);
  });
  return groups;
}
function groupFieldsByCategory(item) {
  const groups = groupFields(item, (field) => {
    if (field.FieldKey.startsWith("login.")) {
      return FieldCategories.Login;
    }
    if (field.FieldKey.startsWith("alias.")) {
      return FieldCategories.Alias;
    }
    if (field.FieldKey.startsWith("card.")) {
      return FieldCategories.Card;
    }
    if (field.FieldKey.startsWith("notes.")) {
      return FieldCategories.Notes;
    }
    if (field.FieldKey.startsWith("metadata.")) {
      return FieldCategories.Metadata;
    }
    return FieldCategories.Custom;
  });
  for (const category of Object.keys(groups)) {
    groups[category].sort((a, b) => (a.DisplayOrder ?? 0) - (b.DisplayOrder ?? 0));
  }
  return groups;
}
function itemToCredential(item) {
  return {
    Id: item.Id,
    Username: getFieldValue(item, FieldKey.LoginUsername),
    Password: getFieldValue(item, FieldKey.LoginPassword) || "",
    ServiceName: item.Name || "",
    ServiceUrl: getFieldValue(item, FieldKey.LoginUrl),
    Logo: item.Logo,
    Notes: getFieldValue(item, FieldKey.NotesContent),
    Alias: {
      FirstName: getFieldValue(item, FieldKey.AliasFirstName),
      LastName: getFieldValue(item, FieldKey.AliasLastName),
      BirthDate: getFieldValue(item, FieldKey.AliasBirthdate) || "",
      Gender: getFieldValue(item, FieldKey.AliasGender),
      Email: getFieldValue(item, FieldKey.LoginEmail)
    },
    HasPasskey: item.HasPasskey,
    HasAttachment: item.HasAttachment
  };
}
function createSystemField(fieldKey, options) {
  const systemField = getSystemField(fieldKey);
  if (!systemField) {
    throw new Error(`Unknown system field: ${fieldKey}. Use createCustomField for custom fields.`);
  }
  return {
    FieldKey: fieldKey,
    Label: options.label ?? fieldKey,
    // UI layer translates via fieldLabels.*
    FieldType: systemField.FieldType,
    Value: options.value,
    IsHidden: systemField.IsHidden,
    DisplayOrder: options.displayOrder ?? systemField.DefaultDisplayOrder,
    IsCustomField: false,
    EnableHistory: systemField.EnableHistory
  };
}
function createCustomField(options) {
  return {
    FieldKey: options.fieldKey,
    Label: options.label,
    FieldType: options.fieldType ?? FieldTypes.Text,
    Value: options.value,
    IsHidden: options.isHidden ?? false,
    DisplayOrder: options.displayOrder ?? 0,
    IsCustomField: true,
    EnableHistory: options.enableHistory ?? false
    // Custom fields don't track history by default
  };
}

// src/vault/FieldHistory.ts
var MAX_FIELD_HISTORY_RECORDS = 10;

export { FieldCategories, FieldKey, FieldTypes, ItemTypes, MAX_FIELD_HISTORY_RECORDS, SystemFieldRegistry, createCustomField, createSystemField, fieldAppliesToType, getAllSystemFieldKeys, getDefaultFieldsForItemType, getFieldConfigForType, getFieldValue, getFieldValues, getOptionalFieldsForItemType, getSystemField, getSystemFieldsForItemType, groupFields, groupFieldsByCategory, hasField, isFieldShownByDefault, isSystemField, isSystemFieldPrefix, itemToCredential };
//# sourceMappingURL=index.js.map
//# sourceMappingURL=index.js.map