/* tslint:disable */
/* eslint-disable */

/**
 * Extract domain from URL.
 *
 * Handles both full URLs and partial domains, returning normalized domain
 * without protocol, www prefix, path, query, or fragment.
 */
export function extractDomain(url: string): string;

/**
 * Extract root domain from a domain string.
 *
 * E.g., "sub.example.com" -> "example.com"
 * E.g., "sub.example.co.uk" -> "example.co.uk"
 */
export function extractRootDomain(domain: string): string;

/**
 * Filter credentials for autofill.
 *
 * Takes a JsValue (CredentialMatcherInput) and returns a JsValue (CredentialMatcherOutput).
 */
export function filterCredentials(input: any): any;

/**
 * Filter credentials using JSON strings (alternative API).
 *
 * Takes a JSON string and returns a JSON string.
 */
export function filterCredentialsJson(input_json: string): string;

/**
 * Get the version of the aliasvault-core library.
 */
export function getCoreVersion(): string;

/**
 * Get the list of table names that need to be synced.
 */
export function getSyncableTableNames(): string[];

/**
 * Initialize panic hook for better error messages.
 */
export function init(): void;

/**
 * Merge vaults using LWW strategy.
 *
 * Takes a JsValue (MergeInput) and returns a JsValue (MergeOutput).
 */
export function mergeVaults(input: any): any;

/**
 * Merge vaults using JSON strings (alternative API).
 *
 * Takes a JSON string and returns a JSON string.
 */
export function mergeVaultsJson(input_json: string): string;

/**
 * Prune expired items from trash.
 *
 * Items with DeletedAt older than retention_days are marked as permanently deleted (IsDeleted = true).
 * Default retention is 30 days.
 *
 * Takes a JsValue (PruneInput) and returns a JsValue (PruneOutput).
 */
export function pruneVault(input: any): any;

/**
 * Prune vault using JSON strings (alternative API).
 *
 * Takes a JSON string and returns a JSON string.
 */
export function pruneVaultJson(input_json: string): string;

/**
 * Derive the SRP private key (x) from credentials.
 *
 * # Arguments
 * * `salt` - Salt as uppercase hex string
 * * `identity` - User identity (username or SRP identity GUID)
 * * `password_hash` - Pre-hashed password as uppercase hex string (from Argon2id)
 *
 * # Returns
 * Private key as uppercase hex string
 */
export function srpDerivePrivateKey(salt: string, identity: string, password_hash: string): string;

/**
 * Derive the client session from server response.
 *
 * # Arguments
 * * `client_secret` - Client secret ephemeral (a) as hex string
 * * `server_public` - Server public ephemeral (B) as hex string
 * * `salt` - Salt as hex string
 * * `identity` - User identity (username or SRP identity GUID)
 * * `private_key` - Private key (x) as hex string
 *
 * # Returns
 * JsValue object with `proof` and `key` properties (uppercase hex strings)
 */
export function srpDeriveSession(client_secret: string, server_public: string, salt: string, identity: string, private_key: string): any;

/**
 * Derive and verify the server session from client response.
 *
 * # Arguments
 * * `server_secret` - Server secret ephemeral (b) as hex string
 * * `client_public` - Client public ephemeral (A) as hex string
 * * `salt` - Salt as hex string
 * * `identity` - User identity (username or SRP identity GUID)
 * * `verifier` - Password verifier (v) as hex string
 * * `client_proof` - Client proof (M1) as hex string
 *
 * # Returns
 * JsValue: object with `proof` and `key` if valid, null if client proof is invalid
 */
export function srpDeriveSessionServer(server_secret: string, client_public: string, salt: string, identity: string, verifier: string, client_proof: string): any;

/**
 * Derive the SRP verifier (v) from a private key.
 *
 * # Arguments
 * * `private_key` - Private key as uppercase hex string
 *
 * # Returns
 * Verifier as uppercase hex string (for registration)
 */
export function srpDeriveVerifier(private_key: string): string;

/**
 * Generate a client ephemeral key pair.
 * Returns a JsValue object with `public` and `secret` properties (uppercase hex strings).
 */
export function srpGenerateEphemeral(): any;

/**
 * Generate a server ephemeral key pair.
 *
 * # Arguments
 * * `verifier` - Password verifier (v) as hex string
 *
 * # Returns
 * JsValue object with `public` and `secret` properties (uppercase hex strings)
 */
export function srpGenerateEphemeralServer(verifier: string): any;

/**
 * Generate a cryptographic salt for SRP.
 * Returns a 32-byte random salt as an uppercase hex string.
 */
export function srpGenerateSalt(): string;

/**
 * Verify the server's session proof (M2) on the client side.
 *
 * This confirms that the server successfully derived the same session key.
 *
 * # Arguments
 * * `client_public` - Client public ephemeral (A) as hex string
 * * `client_proof` - Client proof (M1) as hex string
 * * `session_key` - Session key (K) as hex string
 * * `server_proof` - Server proof (M2) as hex string to verify
 *
 * # Returns
 * True if verification succeeds, false otherwise
 */
export function srpVerifySession(client_public: string, client_proof: string, session_key: string, server_proof: string): boolean;

export type InitInput = RequestInfo | URL | Response | BufferSource | WebAssembly.Module;

export interface InitOutput {
  readonly memory: WebAssembly.Memory;
  readonly extractDomain: (a: number, b: number, c: number) => void;
  readonly extractRootDomain: (a: number, b: number, c: number) => void;
  readonly filterCredentials: (a: number, b: number) => void;
  readonly filterCredentialsJson: (a: number, b: number, c: number) => void;
  readonly getCoreVersion: (a: number) => void;
  readonly getSyncableTableNames: (a: number) => void;
  readonly init: () => void;
  readonly mergeVaults: (a: number, b: number) => void;
  readonly mergeVaultsJson: (a: number, b: number, c: number) => void;
  readonly pruneVault: (a: number, b: number) => void;
  readonly pruneVaultJson: (a: number, b: number, c: number) => void;
  readonly srpDerivePrivateKey: (a: number, b: number, c: number, d: number, e: number, f: number, g: number) => void;
  readonly srpDeriveSession: (a: number, b: number, c: number, d: number, e: number, f: number, g: number, h: number, i: number, j: number, k: number) => void;
  readonly srpDeriveSessionServer: (a: number, b: number, c: number, d: number, e: number, f: number, g: number, h: number, i: number, j: number, k: number, l: number, m: number) => void;
  readonly srpDeriveVerifier: (a: number, b: number, c: number) => void;
  readonly srpGenerateEphemeral: (a: number) => void;
  readonly srpGenerateEphemeralServer: (a: number, b: number, c: number) => void;
  readonly srpGenerateSalt: (a: number) => void;
  readonly srpVerifySession: (a: number, b: number, c: number, d: number, e: number, f: number, g: number, h: number, i: number) => void;
  readonly __wbindgen_export: (a: number, b: number) => number;
  readonly __wbindgen_export2: (a: number, b: number, c: number, d: number) => number;
  readonly __wbindgen_export3: (a: number) => void;
  readonly __wbindgen_export4: (a: number, b: number, c: number) => void;
  readonly __wbindgen_add_to_stack_pointer: (a: number) => number;
  readonly __wbindgen_start: () => void;
}

export type SyncInitInput = BufferSource | WebAssembly.Module;

/**
* Instantiates the given `module`, which can either be bytes or
* a precompiled `WebAssembly.Module`.
*
* @param {{ module: SyncInitInput }} module - Passing `SyncInitInput` directly is deprecated.
*
* @returns {InitOutput}
*/
export function initSync(module: { module: SyncInitInput } | SyncInitInput): InitOutput;

/**
* If `module_or_path` is {RequestInfo} or {URL}, makes a request and
* for everything else, calls `WebAssembly.instantiate` directly.
*
* @param {{ module_or_path: InitInput | Promise<InitInput> }} module_or_path - Passing `InitInput` directly is deprecated.
*
* @returns {Promise<InitOutput>}
*/
export default function __wbg_init (module_or_path?: { module_or_path: InitInput | Promise<InitInput> } | InitInput | Promise<InitInput>): Promise<InitOutput>;
